/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.TabularSource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureMariaDBSource
extends TabularSource {
    private String type = "AzureMariaDBSource";
    private Object query;

    @Override
    public String type() {
        return this.type;
    }

    public Object query() {
        return this.query;
    }

    public AzureMariaDBSource withQuery(Object query) {
        this.query = query;
        return this;
    }

    @Override
    public AzureMariaDBSource withQueryTimeout(Object queryTimeout) {
        super.withQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public AzureMariaDBSource withAdditionalColumns(Object additionalColumns) {
        super.withAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public AzureMariaDBSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public AzureMariaDBSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public AzureMariaDBSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AzureMariaDBSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout());
        jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("query", this.query);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureMariaDBSource fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMariaDBSource)jsonReader.readObject(reader -> {
            AzureMariaDBSource deserializedAzureMariaDBSource = new AzureMariaDBSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedAzureMariaDBSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedAzureMariaDBSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureMariaDBSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedAzureMariaDBSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedAzureMariaDBSource.withQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedAzureMariaDBSource.withAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureMariaDBSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedAzureMariaDBSource.query = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureMariaDBSource.withAdditionalProperties(additionalProperties);
            return deserializedAzureMariaDBSource;
        });
    }
}

