/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AzureKeyVaultLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureKeyVaultLinkedService
extends LinkedService {
    private String type = "AzureKeyVault";
    private AzureKeyVaultLinkedServiceTypeProperties innerTypeProperties = new AzureKeyVaultLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureKeyVaultLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    AzureKeyVaultLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureKeyVaultLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public AzureKeyVaultLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureKeyVaultLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureKeyVaultLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AzureKeyVaultLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object baseUrl() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().baseUrl();
    }

    public AzureKeyVaultLinkedService withBaseUrl(Object baseUrl) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureKeyVaultLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withBaseUrl(baseUrl);
        return this;
    }

    public CredentialReference credential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().credential();
    }

    public AzureKeyVaultLinkedService withCredential(CredentialReference credential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureKeyVaultLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCredential(credential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureKeyVaultLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureKeyVaultLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureKeyVaultLinkedService)jsonReader.readObject(reader -> {
            AzureKeyVaultLinkedService deserializedAzureKeyVaultLinkedService = new AzureKeyVaultLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureKeyVaultLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureKeyVaultLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureKeyVaultLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureKeyVaultLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureKeyVaultLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAzureKeyVaultLinkedService.innerTypeProperties = AzureKeyVaultLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureKeyVaultLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureKeyVaultLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedAzureKeyVaultLinkedService;
        });
    }
}

