/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.MetadataItem;
import com.azure.resourcemanager.datafactory.models.StoreWriteSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureBlobStorageWriteSettings
extends StoreWriteSettings {
    private String type = "AzureBlobStorageWriteSettings";
    private Object blockSizeInMB;

    @Override
    public String type() {
        return this.type;
    }

    public Object blockSizeInMB() {
        return this.blockSizeInMB;
    }

    public AzureBlobStorageWriteSettings withBlockSizeInMB(Object blockSizeInMB) {
        this.blockSizeInMB = blockSizeInMB;
        return this;
    }

    @Override
    public AzureBlobStorageWriteSettings withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AzureBlobStorageWriteSettings withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public AzureBlobStorageWriteSettings withCopyBehavior(Object copyBehavior) {
        super.withCopyBehavior(copyBehavior);
        return this;
    }

    @Override
    public AzureBlobStorageWriteSettings withMetadata(List<MetadataItem> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public void validate() {
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeUntypedField("copyBehavior", this.copyBehavior());
        jsonWriter.writeArrayField("metadata", this.metadata(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("blockSizeInMB", this.blockSizeInMB);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobStorageWriteSettings fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobStorageWriteSettings)jsonReader.readObject(reader -> {
            AzureBlobStorageWriteSettings deserializedAzureBlobStorageWriteSettings = new AzureBlobStorageWriteSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureBlobStorageWriteSettings.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedAzureBlobStorageWriteSettings.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("copyBehavior".equals(fieldName)) {
                    deserializedAzureBlobStorageWriteSettings.withCopyBehavior(reader.readUntyped());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    deserializedAzureBlobStorageWriteSettings.withMetadata(metadata);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureBlobStorageWriteSettings.type = reader.getString();
                    continue;
                }
                if ("blockSizeInMB".equals(fieldName)) {
                    deserializedAzureBlobStorageWriteSettings.blockSizeInMB = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureBlobStorageWriteSettings.withAdditionalProperties(additionalProperties);
            return deserializedAzureBlobStorageWriteSettings;
        });
    }
}

