/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureBlobFSSource
extends CopySource {
    private String type = "AzureBlobFSSource";
    private Object treatEmptyAsNull;
    private Object skipHeaderLineCount;
    private Object recursive;

    @Override
    public String type() {
        return this.type;
    }

    public Object treatEmptyAsNull() {
        return this.treatEmptyAsNull;
    }

    public AzureBlobFSSource withTreatEmptyAsNull(Object treatEmptyAsNull) {
        this.treatEmptyAsNull = treatEmptyAsNull;
        return this;
    }

    public Object skipHeaderLineCount() {
        return this.skipHeaderLineCount;
    }

    public AzureBlobFSSource withSkipHeaderLineCount(Object skipHeaderLineCount) {
        this.skipHeaderLineCount = skipHeaderLineCount;
        return this;
    }

    public Object recursive() {
        return this.recursive;
    }

    public AzureBlobFSSource withRecursive(Object recursive) {
        this.recursive = recursive;
        return this;
    }

    @Override
    public AzureBlobFSSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public AzureBlobFSSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public AzureBlobFSSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AzureBlobFSSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("treatEmptyAsNull", this.treatEmptyAsNull);
        jsonWriter.writeUntypedField("skipHeaderLineCount", this.skipHeaderLineCount);
        jsonWriter.writeUntypedField("recursive", this.recursive);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobFSSource fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobFSSource)jsonReader.readObject(reader -> {
            AzureBlobFSSource deserializedAzureBlobFSSource = new AzureBlobFSSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedAzureBlobFSSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedAzureBlobFSSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureBlobFSSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedAzureBlobFSSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureBlobFSSource.type = reader.getString();
                    continue;
                }
                if ("treatEmptyAsNull".equals(fieldName)) {
                    deserializedAzureBlobFSSource.treatEmptyAsNull = reader.readUntyped();
                    continue;
                }
                if ("skipHeaderLineCount".equals(fieldName)) {
                    deserializedAzureBlobFSSource.skipHeaderLineCount = reader.readUntyped();
                    continue;
                }
                if ("recursive".equals(fieldName)) {
                    deserializedAzureBlobFSSource.recursive = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureBlobFSSource.withAdditionalProperties(additionalProperties);
            return deserializedAzureBlobFSSource;
        });
    }
}

