/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.FormatWriteSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AvroWriteSettings
extends FormatWriteSettings {
    private String type = "AvroWriteSettings";
    private String recordName;
    private String recordNamespace;
    private Object maxRowsPerFile;
    private Object fileNamePrefix;

    @Override
    public String type() {
        return this.type;
    }

    public String recordName() {
        return this.recordName;
    }

    public AvroWriteSettings withRecordName(String recordName) {
        this.recordName = recordName;
        return this;
    }

    public String recordNamespace() {
        return this.recordNamespace;
    }

    public AvroWriteSettings withRecordNamespace(String recordNamespace) {
        this.recordNamespace = recordNamespace;
        return this;
    }

    public Object maxRowsPerFile() {
        return this.maxRowsPerFile;
    }

    public AvroWriteSettings withMaxRowsPerFile(Object maxRowsPerFile) {
        this.maxRowsPerFile = maxRowsPerFile;
        return this;
    }

    public Object fileNamePrefix() {
        return this.fileNamePrefix;
    }

    public AvroWriteSettings withFileNamePrefix(Object fileNamePrefix) {
        this.fileNamePrefix = fileNamePrefix;
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("recordName", this.recordName);
        jsonWriter.writeStringField("recordNamespace", this.recordNamespace);
        jsonWriter.writeUntypedField("maxRowsPerFile", this.maxRowsPerFile);
        jsonWriter.writeUntypedField("fileNamePrefix", this.fileNamePrefix);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AvroWriteSettings fromJson(JsonReader jsonReader) throws IOException {
        return (AvroWriteSettings)jsonReader.readObject(reader -> {
            AvroWriteSettings deserializedAvroWriteSettings = new AvroWriteSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedAvroWriteSettings.type = reader.getString();
                    continue;
                }
                if ("recordName".equals(fieldName)) {
                    deserializedAvroWriteSettings.recordName = reader.getString();
                    continue;
                }
                if ("recordNamespace".equals(fieldName)) {
                    deserializedAvroWriteSettings.recordNamespace = reader.getString();
                    continue;
                }
                if ("maxRowsPerFile".equals(fieldName)) {
                    deserializedAvroWriteSettings.maxRowsPerFile = reader.readUntyped();
                    continue;
                }
                if ("fileNamePrefix".equals(fieldName)) {
                    deserializedAvroWriteSettings.fileNamePrefix = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAvroWriteSettings.withAdditionalProperties(additionalProperties);
            return deserializedAvroWriteSettings;
        });
    }
}

