/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.models.TriggerResourceInner;
import com.azure.resourcemanager.datafactory.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datafactory.models.Trigger;
import com.azure.resourcemanager.datafactory.models.TriggerResource;
import com.azure.resourcemanager.datafactory.models.TriggerSubscriptionOperationStatus;

public final class TriggerResourceImpl
implements TriggerResource,
TriggerResource.Definition,
TriggerResource.Update {
    private TriggerResourceInner innerObject;
    private final DataFactoryManager serviceManager;
    private String resourceGroupName;
    private String factoryName;
    private String triggerName;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public Trigger properties() {
        return this.innerModel().properties();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public TriggerResourceInner innerModel() {
        return this.innerObject;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public TriggerResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    @Override
    public TriggerResource create() {
        this.innerObject = (TriggerResourceInner)((Object)this.serviceManager.serviceClient().getTriggers().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.triggerName, this.innerModel(), this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public TriggerResource create(Context context) {
        this.innerObject = (TriggerResourceInner)((Object)this.serviceManager.serviceClient().getTriggers().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.triggerName, this.innerModel(), this.createIfMatch, context).getValue());
        return this;
    }

    TriggerResourceImpl(String name, DataFactoryManager serviceManager) {
        this.innerObject = new TriggerResourceInner();
        this.serviceManager = serviceManager;
        this.triggerName = name;
        this.createIfMatch = null;
    }

    @Override
    public TriggerResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public TriggerResource apply() {
        this.innerObject = (TriggerResourceInner)((Object)this.serviceManager.serviceClient().getTriggers().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.triggerName, this.innerModel(), this.updateIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public TriggerResource apply(Context context) {
        this.innerObject = (TriggerResourceInner)((Object)this.serviceManager.serviceClient().getTriggers().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.triggerName, this.innerModel(), this.updateIfMatch, context).getValue());
        return this;
    }

    TriggerResourceImpl(TriggerResourceInner innerObject, DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "factories");
        this.triggerName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "triggers");
    }

    @Override
    public TriggerResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = (TriggerResourceInner)((Object)this.serviceManager.serviceClient().getTriggers().getWithResponse(this.resourceGroupName, this.factoryName, this.triggerName, localIfNoneMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public TriggerResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = (TriggerResourceInner)((Object)this.serviceManager.serviceClient().getTriggers().getWithResponse(this.resourceGroupName, this.factoryName, this.triggerName, localIfNoneMatch, context).getValue());
        return this;
    }

    @Override
    public TriggerSubscriptionOperationStatus subscribeToEvents() {
        return this.serviceManager.triggers().subscribeToEvents(this.resourceGroupName, this.factoryName, this.triggerName);
    }

    @Override
    public TriggerSubscriptionOperationStatus subscribeToEvents(Context context) {
        return this.serviceManager.triggers().subscribeToEvents(this.resourceGroupName, this.factoryName, this.triggerName, context);
    }

    @Override
    public Response<TriggerSubscriptionOperationStatus> getEventSubscriptionStatusWithResponse(Context context) {
        return this.serviceManager.triggers().getEventSubscriptionStatusWithResponse(this.resourceGroupName, this.factoryName, this.triggerName, context);
    }

    @Override
    public TriggerSubscriptionOperationStatus getEventSubscriptionStatus() {
        return this.serviceManager.triggers().getEventSubscriptionStatus(this.resourceGroupName, this.factoryName, this.triggerName);
    }

    @Override
    public TriggerSubscriptionOperationStatus unsubscribeFromEvents() {
        return this.serviceManager.triggers().unsubscribeFromEvents(this.resourceGroupName, this.factoryName, this.triggerName);
    }

    @Override
    public TriggerSubscriptionOperationStatus unsubscribeFromEvents(Context context) {
        return this.serviceManager.triggers().unsubscribeFromEvents(this.resourceGroupName, this.factoryName, this.triggerName, context);
    }

    @Override
    public void start() {
        this.serviceManager.triggers().start(this.resourceGroupName, this.factoryName, this.triggerName);
    }

    @Override
    public void start(Context context) {
        this.serviceManager.triggers().start(this.resourceGroupName, this.factoryName, this.triggerName, context);
    }

    @Override
    public void stop() {
        this.serviceManager.triggers().stop(this.resourceGroupName, this.factoryName, this.triggerName);
    }

    @Override
    public void stop(Context context) {
        this.serviceManager.triggers().stop(this.resourceGroupName, this.factoryName, this.triggerName, context);
    }

    @Override
    public TriggerResourceImpl withProperties(Trigger properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public TriggerResourceImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

