/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.PipelineRunsClient;
import com.azure.resourcemanager.datafactory.fluent.models.PipelineRunInner;
import com.azure.resourcemanager.datafactory.fluent.models.PipelineRunsQueryResponseInner;
import com.azure.resourcemanager.datafactory.implementation.PipelineRunImpl;
import com.azure.resourcemanager.datafactory.implementation.PipelineRunsQueryResponseImpl;
import com.azure.resourcemanager.datafactory.models.PipelineRun;
import com.azure.resourcemanager.datafactory.models.PipelineRuns;
import com.azure.resourcemanager.datafactory.models.PipelineRunsQueryResponse;
import com.azure.resourcemanager.datafactory.models.RunFilterParameters;

public final class PipelineRunsImpl
implements PipelineRuns {
    private static final ClientLogger LOGGER = new ClientLogger(PipelineRunsImpl.class);
    private final PipelineRunsClient innerClient;
    private final DataFactoryManager serviceManager;

    public PipelineRunsImpl(PipelineRunsClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PipelineRunsQueryResponse> queryByFactoryWithResponse(String resourceGroupName, String factoryName, RunFilterParameters filterParameters, Context context) {
        Response<PipelineRunsQueryResponseInner> inner = this.serviceClient().queryByFactoryWithResponse(resourceGroupName, factoryName, filterParameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PipelineRunsQueryResponseImpl((PipelineRunsQueryResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PipelineRunsQueryResponse queryByFactory(String resourceGroupName, String factoryName, RunFilterParameters filterParameters) {
        PipelineRunsQueryResponseInner inner = this.serviceClient().queryByFactory(resourceGroupName, factoryName, filterParameters);
        if (inner != null) {
            return new PipelineRunsQueryResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PipelineRun> getWithResponse(String resourceGroupName, String factoryName, String runId, Context context) {
        Response<PipelineRunInner> inner = this.serviceClient().getWithResponse(resourceGroupName, factoryName, runId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PipelineRunImpl((PipelineRunInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PipelineRun get(String resourceGroupName, String factoryName, String runId) {
        PipelineRunInner inner = this.serviceClient().get(resourceGroupName, factoryName, runId);
        if (inner != null) {
            return new PipelineRunImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> cancelWithResponse(String resourceGroupName, String factoryName, String runId, Boolean isRecursive, Context context) {
        return this.serviceClient().cancelWithResponse(resourceGroupName, factoryName, runId, isRecursive, context);
    }

    @Override
    public void cancel(String resourceGroupName, String factoryName, String runId) {
        this.serviceClient().cancel(resourceGroupName, factoryName, runId);
    }

    private PipelineRunsClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }
}

