/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;

public final class XmlDatasetTypeProperties
implements JsonSerializable<XmlDatasetTypeProperties> {
    private DatasetLocation location;
    private Object encodingName;
    private Object nullValue;
    private DatasetCompression compression;
    private static final ClientLogger LOGGER = new ClientLogger(XmlDatasetTypeProperties.class);

    public DatasetLocation location() {
        return this.location;
    }

    public XmlDatasetTypeProperties withLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    public Object encodingName() {
        return this.encodingName;
    }

    public XmlDatasetTypeProperties withEncodingName(Object encodingName) {
        this.encodingName = encodingName;
        return this;
    }

    public Object nullValue() {
        return this.nullValue;
    }

    public XmlDatasetTypeProperties withNullValue(Object nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    public DatasetCompression compression() {
        return this.compression;
    }

    public XmlDatasetTypeProperties withCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model XmlDatasetTypeProperties"));
        }
        this.location().validate();
        if (this.compression() != null) {
            this.compression().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("location", (JsonSerializable)this.location);
        jsonWriter.writeUntypedField("encodingName", this.encodingName);
        jsonWriter.writeUntypedField("nullValue", this.nullValue);
        jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
        return jsonWriter.writeEndObject();
    }

    public static XmlDatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (XmlDatasetTypeProperties)jsonReader.readObject(reader -> {
            XmlDatasetTypeProperties deserializedXmlDatasetTypeProperties = new XmlDatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedXmlDatasetTypeProperties.location = DatasetLocation.fromJson(reader);
                    continue;
                }
                if ("encodingName".equals(fieldName)) {
                    deserializedXmlDatasetTypeProperties.encodingName = reader.readUntyped();
                    continue;
                }
                if ("nullValue".equals(fieldName)) {
                    deserializedXmlDatasetTypeProperties.nullValue = reader.readUntyped();
                    continue;
                }
                if ("compression".equals(fieldName)) {
                    deserializedXmlDatasetTypeProperties.compression = DatasetCompression.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedXmlDatasetTypeProperties;
        });
    }
}

