/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.TeradataAuthenticationType;
import java.io.IOException;

public final class TeradataLinkedServiceTypeProperties
implements JsonSerializable<TeradataLinkedServiceTypeProperties> {
    private Object connectionString;
    private Object server;
    private TeradataAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object sslMode;
    private Object portNumber;
    private Object httpsPortNumber;
    private Object useDataEncryption;
    private Object characterSet;
    private Object maxRespSize;
    private String encryptedCredential;

    public Object connectionString() {
        return this.connectionString;
    }

    public TeradataLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object server() {
        return this.server;
    }

    public TeradataLinkedServiceTypeProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    public TeradataAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public TeradataLinkedServiceTypeProperties withAuthenticationType(TeradataAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public TeradataLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public TeradataLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object sslMode() {
        return this.sslMode;
    }

    public TeradataLinkedServiceTypeProperties withSslMode(Object sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    public Object portNumber() {
        return this.portNumber;
    }

    public TeradataLinkedServiceTypeProperties withPortNumber(Object portNumber) {
        this.portNumber = portNumber;
        return this;
    }

    public Object httpsPortNumber() {
        return this.httpsPortNumber;
    }

    public TeradataLinkedServiceTypeProperties withHttpsPortNumber(Object httpsPortNumber) {
        this.httpsPortNumber = httpsPortNumber;
        return this;
    }

    public Object useDataEncryption() {
        return this.useDataEncryption;
    }

    public TeradataLinkedServiceTypeProperties withUseDataEncryption(Object useDataEncryption) {
        this.useDataEncryption = useDataEncryption;
        return this;
    }

    public Object characterSet() {
        return this.characterSet;
    }

    public TeradataLinkedServiceTypeProperties withCharacterSet(Object characterSet) {
        this.characterSet = characterSet;
        return this;
    }

    public Object maxRespSize() {
        return this.maxRespSize;
    }

    public TeradataLinkedServiceTypeProperties withMaxRespSize(Object maxRespSize) {
        this.maxRespSize = maxRespSize;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public TeradataLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("connectionString", this.connectionString);
        jsonWriter.writeUntypedField("server", this.server);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeUntypedField("username", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeUntypedField("sslMode", this.sslMode);
        jsonWriter.writeUntypedField("portNumber", this.portNumber);
        jsonWriter.writeUntypedField("httpsPortNumber", this.httpsPortNumber);
        jsonWriter.writeUntypedField("useDataEncryption", this.useDataEncryption);
        jsonWriter.writeUntypedField("characterSet", this.characterSet);
        jsonWriter.writeUntypedField("maxRespSize", this.maxRespSize);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static TeradataLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TeradataLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            TeradataLinkedServiceTypeProperties deserializedTeradataLinkedServiceTypeProperties = new TeradataLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedTeradataLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("server".equals(fieldName)) {
                    deserializedTeradataLinkedServiceTypeProperties.server = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedTeradataLinkedServiceTypeProperties.authenticationType = TeradataAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedTeradataLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedTeradataLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("sslMode".equals(fieldName)) {
                    deserializedTeradataLinkedServiceTypeProperties.sslMode = reader.readUntyped();
                    continue;
                }
                if ("portNumber".equals(fieldName)) {
                    deserializedTeradataLinkedServiceTypeProperties.portNumber = reader.readUntyped();
                    continue;
                }
                if ("httpsPortNumber".equals(fieldName)) {
                    deserializedTeradataLinkedServiceTypeProperties.httpsPortNumber = reader.readUntyped();
                    continue;
                }
                if ("useDataEncryption".equals(fieldName)) {
                    deserializedTeradataLinkedServiceTypeProperties.useDataEncryption = reader.readUntyped();
                    continue;
                }
                if ("characterSet".equals(fieldName)) {
                    deserializedTeradataLinkedServiceTypeProperties.characterSet = reader.readUntyped();
                    continue;
                }
                if ("maxRespSize".equals(fieldName)) {
                    deserializedTeradataLinkedServiceTypeProperties.maxRespSize = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedTeradataLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTeradataLinkedServiceTypeProperties;
        });
    }
}

