/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SqlAlwaysEncryptedProperties;
import com.azure.resourcemanager.datafactory.models.SqlServerAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SqlServerBaseLinkedServiceTypeProperties;
import java.io.IOException;

public final class SqlServerLinkedServiceTypeProperties
extends SqlServerBaseLinkedServiceTypeProperties {
    private Object connectionString;
    private SqlServerAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private String encryptedCredential;
    private SqlAlwaysEncryptedProperties alwaysEncryptedSettings;
    private CredentialReference credential;

    public Object connectionString() {
        return this.connectionString;
    }

    public SqlServerLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public SqlServerAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public SqlServerLinkedServiceTypeProperties withAuthenticationType(SqlServerAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public SqlServerLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public SqlServerLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public SqlServerLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public SqlAlwaysEncryptedProperties alwaysEncryptedSettings() {
        return this.alwaysEncryptedSettings;
    }

    public SqlServerLinkedServiceTypeProperties withAlwaysEncryptedSettings(SqlAlwaysEncryptedProperties alwaysEncryptedSettings) {
        this.alwaysEncryptedSettings = alwaysEncryptedSettings;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public SqlServerLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withServer(Object server) {
        super.withServer(server);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withDatabase(Object database) {
        super.withDatabase(database);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withEncrypt(Object encrypt) {
        super.withEncrypt(encrypt);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withTrustServerCertificate(Object trustServerCertificate) {
        super.withTrustServerCertificate(trustServerCertificate);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withHostnameInCertificate(Object hostnameInCertificate) {
        super.withHostnameInCertificate(hostnameInCertificate);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withApplicationIntent(Object applicationIntent) {
        super.withApplicationIntent(applicationIntent);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withConnectTimeout(Object connectTimeout) {
        super.withConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withConnectRetryCount(Object connectRetryCount) {
        super.withConnectRetryCount(connectRetryCount);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withConnectRetryInterval(Object connectRetryInterval) {
        super.withConnectRetryInterval(connectRetryInterval);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withLoadBalanceTimeout(Object loadBalanceTimeout) {
        super.withLoadBalanceTimeout(loadBalanceTimeout);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withCommandTimeout(Object commandTimeout) {
        super.withCommandTimeout(commandTimeout);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withIntegratedSecurity(Object integratedSecurity) {
        super.withIntegratedSecurity(integratedSecurity);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withFailoverPartner(Object failoverPartner) {
        super.withFailoverPartner(failoverPartner);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withMaxPoolSize(Object maxPoolSize) {
        super.withMaxPoolSize(maxPoolSize);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withMinPoolSize(Object minPoolSize) {
        super.withMinPoolSize(minPoolSize);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withMultipleActiveResultSets(Object multipleActiveResultSets) {
        super.withMultipleActiveResultSets(multipleActiveResultSets);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withMultiSubnetFailover(Object multiSubnetFailover) {
        super.withMultiSubnetFailover(multiSubnetFailover);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withPacketSize(Object packetSize) {
        super.withPacketSize(packetSize);
        return this;
    }

    @Override
    public SqlServerLinkedServiceTypeProperties withPooling(Object pooling) {
        super.withPooling(pooling);
        return this;
    }

    @Override
    public void validate() {
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.alwaysEncryptedSettings() != null) {
            this.alwaysEncryptedSettings().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("server", this.server());
        jsonWriter.writeUntypedField("database", this.database());
        jsonWriter.writeUntypedField("encrypt", this.encrypt());
        jsonWriter.writeUntypedField("trustServerCertificate", this.trustServerCertificate());
        jsonWriter.writeUntypedField("hostNameInCertificate", this.hostnameInCertificate());
        jsonWriter.writeUntypedField("applicationIntent", this.applicationIntent());
        jsonWriter.writeUntypedField("connectTimeout", this.connectTimeout());
        jsonWriter.writeUntypedField("connectRetryCount", this.connectRetryCount());
        jsonWriter.writeUntypedField("connectRetryInterval", this.connectRetryInterval());
        jsonWriter.writeUntypedField("loadBalanceTimeout", this.loadBalanceTimeout());
        jsonWriter.writeUntypedField("commandTimeout", this.commandTimeout());
        jsonWriter.writeUntypedField("integratedSecurity", this.integratedSecurity());
        jsonWriter.writeUntypedField("failoverPartner", this.failoverPartner());
        jsonWriter.writeUntypedField("maxPoolSize", this.maxPoolSize());
        jsonWriter.writeUntypedField("minPoolSize", this.minPoolSize());
        jsonWriter.writeUntypedField("multipleActiveResultSets", this.multipleActiveResultSets());
        jsonWriter.writeUntypedField("multiSubnetFailover", this.multiSubnetFailover());
        jsonWriter.writeUntypedField("packetSize", this.packetSize());
        jsonWriter.writeUntypedField("pooling", this.pooling());
        jsonWriter.writeUntypedField("connectionString", this.connectionString);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeUntypedField("userName", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeJsonField("alwaysEncryptedSettings", (JsonSerializable)this.alwaysEncryptedSettings);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static SqlServerLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SqlServerLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            SqlServerLinkedServiceTypeProperties deserializedSqlServerLinkedServiceTypeProperties = new SqlServerLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withServer(reader.readUntyped());
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withDatabase(reader.readUntyped());
                    continue;
                }
                if ("encrypt".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withEncrypt(reader.readUntyped());
                    continue;
                }
                if ("trustServerCertificate".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withTrustServerCertificate(reader.readUntyped());
                    continue;
                }
                if ("hostNameInCertificate".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withHostnameInCertificate(reader.readUntyped());
                    continue;
                }
                if ("applicationIntent".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withApplicationIntent(reader.readUntyped());
                    continue;
                }
                if ("connectTimeout".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withConnectTimeout(reader.readUntyped());
                    continue;
                }
                if ("connectRetryCount".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withConnectRetryCount(reader.readUntyped());
                    continue;
                }
                if ("connectRetryInterval".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withConnectRetryInterval(reader.readUntyped());
                    continue;
                }
                if ("loadBalanceTimeout".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withLoadBalanceTimeout(reader.readUntyped());
                    continue;
                }
                if ("commandTimeout".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withCommandTimeout(reader.readUntyped());
                    continue;
                }
                if ("integratedSecurity".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withIntegratedSecurity(reader.readUntyped());
                    continue;
                }
                if ("failoverPartner".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withFailoverPartner(reader.readUntyped());
                    continue;
                }
                if ("maxPoolSize".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withMaxPoolSize(reader.readUntyped());
                    continue;
                }
                if ("minPoolSize".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withMinPoolSize(reader.readUntyped());
                    continue;
                }
                if ("multipleActiveResultSets".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withMultipleActiveResultSets(reader.readUntyped());
                    continue;
                }
                if ("multiSubnetFailover".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withMultiSubnetFailover(reader.readUntyped());
                    continue;
                }
                if ("packetSize".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withPacketSize(reader.readUntyped());
                    continue;
                }
                if ("pooling".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.withPooling(reader.readUntyped());
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.authenticationType = SqlServerAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("alwaysEncryptedSettings".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.alwaysEncryptedSettings = SqlAlwaysEncryptedProperties.fromJson(reader);
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedSqlServerLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlServerLinkedServiceTypeProperties;
        });
    }
}

