/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.ServiceNowAuthenticationType;
import java.io.IOException;

public final class ServiceNowLinkedServiceTypeProperties
implements JsonSerializable<ServiceNowLinkedServiceTypeProperties> {
    private Object endpoint;
    private ServiceNowAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object clientId;
    private SecretBase clientSecret;
    private Object useEncryptedEndpoints;
    private Object useHostVerification;
    private Object usePeerVerification;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(ServiceNowLinkedServiceTypeProperties.class);

    public Object endpoint() {
        return this.endpoint;
    }

    public ServiceNowLinkedServiceTypeProperties withEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ServiceNowAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public ServiceNowLinkedServiceTypeProperties withAuthenticationType(ServiceNowAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public ServiceNowLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public ServiceNowLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object clientId() {
        return this.clientId;
    }

    public ServiceNowLinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    public ServiceNowLinkedServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object useEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public ServiceNowLinkedServiceTypeProperties withUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object useHostVerification() {
        return this.useHostVerification;
    }

    public ServiceNowLinkedServiceTypeProperties withUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    public Object usePeerVerification() {
        return this.usePeerVerification;
    }

    public ServiceNowLinkedServiceTypeProperties withUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public ServiceNowLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.endpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endpoint in model ServiceNowLinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model ServiceNowLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.clientSecret() != null) {
            this.clientSecret().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("endpoint", this.endpoint);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeUntypedField("username", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeUntypedField("clientId", this.clientId);
        jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
        jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
        jsonWriter.writeUntypedField("useHostVerification", this.useHostVerification);
        jsonWriter.writeUntypedField("usePeerVerification", this.usePeerVerification);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static ServiceNowLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceNowLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            ServiceNowLinkedServiceTypeProperties deserializedServiceNowLinkedServiceTypeProperties = new ServiceNowLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoint".equals(fieldName)) {
                    deserializedServiceNowLinkedServiceTypeProperties.endpoint = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedServiceNowLinkedServiceTypeProperties.authenticationType = ServiceNowAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedServiceNowLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedServiceNowLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedServiceNowLinkedServiceTypeProperties.clientId = reader.readUntyped();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedServiceNowLinkedServiceTypeProperties.clientSecret = SecretBase.fromJson(reader);
                    continue;
                }
                if ("useEncryptedEndpoints".equals(fieldName)) {
                    deserializedServiceNowLinkedServiceTypeProperties.useEncryptedEndpoints = reader.readUntyped();
                    continue;
                }
                if ("useHostVerification".equals(fieldName)) {
                    deserializedServiceNowLinkedServiceTypeProperties.useHostVerification = reader.readUntyped();
                    continue;
                }
                if ("usePeerVerification".equals(fieldName)) {
                    deserializedServiceNowLinkedServiceTypeProperties.usePeerVerification = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedServiceNowLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceNowLinkedServiceTypeProperties;
        });
    }
}

