/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class SapCloudForCustomerLinkedServiceTypeProperties
implements JsonSerializable<SapCloudForCustomerLinkedServiceTypeProperties> {
    private Object url;
    private Object username;
    private SecretBase password;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(SapCloudForCustomerLinkedServiceTypeProperties.class);

    public Object url() {
        return this.url;
    }

    public SapCloudForCustomerLinkedServiceTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public SapCloudForCustomerLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public SapCloudForCustomerLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public SapCloudForCustomerLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model SapCloudForCustomerLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.url);
        jsonWriter.writeUntypedField("username", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static SapCloudForCustomerLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SapCloudForCustomerLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            SapCloudForCustomerLinkedServiceTypeProperties deserializedSapCloudForCustomerLinkedServiceTypeProperties = new SapCloudForCustomerLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedSapCloudForCustomerLinkedServiceTypeProperties.url = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedSapCloudForCustomerLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSapCloudForCustomerLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedSapCloudForCustomerLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapCloudForCustomerLinkedServiceTypeProperties;
        });
    }
}

