/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.PowerQuerySource;
import java.io.IOException;
import java.util.List;

public final class PowerQueryTypeProperties
implements JsonSerializable<PowerQueryTypeProperties> {
    private List<PowerQuerySource> sources;
    private String script;
    private String documentLocale;

    public List<PowerQuerySource> sources() {
        return this.sources;
    }

    public PowerQueryTypeProperties withSources(List<PowerQuerySource> sources) {
        this.sources = sources;
        return this;
    }

    public String script() {
        return this.script;
    }

    public PowerQueryTypeProperties withScript(String script) {
        this.script = script;
        return this;
    }

    public String documentLocale() {
        return this.documentLocale;
    }

    public PowerQueryTypeProperties withDocumentLocale(String documentLocale) {
        this.documentLocale = documentLocale;
        return this;
    }

    public void validate() {
        if (this.sources() != null) {
            this.sources().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("sources", this.sources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("script", this.script);
        jsonWriter.writeStringField("documentLocale", this.documentLocale);
        return jsonWriter.writeEndObject();
    }

    public static PowerQueryTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PowerQueryTypeProperties)jsonReader.readObject(reader -> {
            PowerQueryTypeProperties deserializedPowerQueryTypeProperties = new PowerQueryTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sources".equals(fieldName)) {
                    List sources;
                    deserializedPowerQueryTypeProperties.sources = sources = reader.readArray(reader1 -> PowerQuerySource.fromJson(reader1));
                    continue;
                }
                if ("script".equals(fieldName)) {
                    deserializedPowerQueryTypeProperties.script = reader.getString();
                    continue;
                }
                if ("documentLocale".equals(fieldName)) {
                    deserializedPowerQueryTypeProperties.documentLocale = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPowerQueryTypeProperties;
        });
    }
}

