/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class MarketoLinkedServiceTypeProperties
implements JsonSerializable<MarketoLinkedServiceTypeProperties> {
    private Object endpoint;
    private Object clientId;
    private SecretBase clientSecret;
    private Object useEncryptedEndpoints;
    private Object useHostVerification;
    private Object usePeerVerification;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(MarketoLinkedServiceTypeProperties.class);

    public Object endpoint() {
        return this.endpoint;
    }

    public MarketoLinkedServiceTypeProperties withEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Object clientId() {
        return this.clientId;
    }

    public MarketoLinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    public MarketoLinkedServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object useEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public MarketoLinkedServiceTypeProperties withUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object useHostVerification() {
        return this.useHostVerification;
    }

    public MarketoLinkedServiceTypeProperties withUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    public Object usePeerVerification() {
        return this.usePeerVerification;
    }

    public MarketoLinkedServiceTypeProperties withUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public MarketoLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.endpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endpoint in model MarketoLinkedServiceTypeProperties"));
        }
        if (this.clientId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clientId in model MarketoLinkedServiceTypeProperties"));
        }
        if (this.clientSecret() != null) {
            this.clientSecret().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("endpoint", this.endpoint);
        jsonWriter.writeUntypedField("clientId", this.clientId);
        jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
        jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
        jsonWriter.writeUntypedField("useHostVerification", this.useHostVerification);
        jsonWriter.writeUntypedField("usePeerVerification", this.usePeerVerification);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static MarketoLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MarketoLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            MarketoLinkedServiceTypeProperties deserializedMarketoLinkedServiceTypeProperties = new MarketoLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoint".equals(fieldName)) {
                    deserializedMarketoLinkedServiceTypeProperties.endpoint = reader.readUntyped();
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedMarketoLinkedServiceTypeProperties.clientId = reader.readUntyped();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedMarketoLinkedServiceTypeProperties.clientSecret = SecretBase.fromJson(reader);
                    continue;
                }
                if ("useEncryptedEndpoints".equals(fieldName)) {
                    deserializedMarketoLinkedServiceTypeProperties.useEncryptedEndpoints = reader.readUntyped();
                    continue;
                }
                if ("useHostVerification".equals(fieldName)) {
                    deserializedMarketoLinkedServiceTypeProperties.useHostVerification = reader.readUntyped();
                    continue;
                }
                if ("usePeerVerification".equals(fieldName)) {
                    deserializedMarketoLinkedServiceTypeProperties.usePeerVerification = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedMarketoLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMarketoLinkedServiceTypeProperties;
        });
    }
}

