/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ManagedVirtualNetwork;
import java.io.IOException;

public final class ManagedVirtualNetworkResourceInner
extends SubResource {
    private ManagedVirtualNetwork properties;
    private String name;
    private String type;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedVirtualNetworkResourceInner.class);

    public ManagedVirtualNetwork properties() {
        return this.properties;
    }

    public ManagedVirtualNetworkResourceInner withProperties(ManagedVirtualNetwork properties) {
        this.properties = properties;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public ManagedVirtualNetworkResourceInner withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model ManagedVirtualNetworkResourceInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ManagedVirtualNetworkResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedVirtualNetworkResourceInner)((Object)jsonReader.readObject(reader -> {
            ManagedVirtualNetworkResourceInner deserializedManagedVirtualNetworkResourceInner = new ManagedVirtualNetworkResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedVirtualNetworkResourceInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedVirtualNetworkResourceInner.properties = ManagedVirtualNetwork.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedVirtualNetworkResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedVirtualNetworkResourceInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedManagedVirtualNetworkResourceInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedVirtualNetworkResourceInner;
        }));
    }
}

