/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ManagedIntegrationRuntimeError;
import com.azure.resourcemanager.datafactory.models.ManagedIntegrationRuntimeNode;
import com.azure.resourcemanager.datafactory.models.ManagedIntegrationRuntimeOperationResult;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ManagedIntegrationRuntimeStatusTypeProperties
implements JsonSerializable<ManagedIntegrationRuntimeStatusTypeProperties> {
    private OffsetDateTime createTime;
    private List<ManagedIntegrationRuntimeNode> nodes;
    private List<ManagedIntegrationRuntimeError> otherErrors;
    private ManagedIntegrationRuntimeOperationResult lastOperation;

    public OffsetDateTime createTime() {
        return this.createTime;
    }

    public List<ManagedIntegrationRuntimeNode> nodes() {
        return this.nodes;
    }

    public List<ManagedIntegrationRuntimeError> otherErrors() {
        return this.otherErrors;
    }

    public ManagedIntegrationRuntimeOperationResult lastOperation() {
        return this.lastOperation;
    }

    public void validate() {
        if (this.nodes() != null) {
            this.nodes().forEach(e -> e.validate());
        }
        if (this.otherErrors() != null) {
            this.otherErrors().forEach(e -> e.validate());
        }
        if (this.lastOperation() != null) {
            this.lastOperation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ManagedIntegrationRuntimeStatusTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedIntegrationRuntimeStatusTypeProperties)jsonReader.readObject(reader -> {
            ManagedIntegrationRuntimeStatusTypeProperties deserializedManagedIntegrationRuntimeStatusTypeProperties = new ManagedIntegrationRuntimeStatusTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createTime".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeStatusTypeProperties.createTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("nodes".equals(fieldName)) {
                    List nodes;
                    deserializedManagedIntegrationRuntimeStatusTypeProperties.nodes = nodes = reader.readArray(reader1 -> ManagedIntegrationRuntimeNode.fromJson(reader1));
                    continue;
                }
                if ("otherErrors".equals(fieldName)) {
                    List otherErrors;
                    deserializedManagedIntegrationRuntimeStatusTypeProperties.otherErrors = otherErrors = reader.readArray(reader1 -> ManagedIntegrationRuntimeError.fromJson(reader1));
                    continue;
                }
                if ("lastOperation".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeStatusTypeProperties.lastOperation = ManagedIntegrationRuntimeOperationResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedIntegrationRuntimeStatusTypeProperties;
        });
    }
}

