/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class InformixLinkedServiceTypeProperties
implements JsonSerializable<InformixLinkedServiceTypeProperties> {
    private Object connectionString;
    private Object authenticationType;
    private SecretBase credential;
    private Object username;
    private SecretBase password;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(InformixLinkedServiceTypeProperties.class);

    public Object connectionString() {
        return this.connectionString;
    }

    public InformixLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object authenticationType() {
        return this.authenticationType;
    }

    public InformixLinkedServiceTypeProperties withAuthenticationType(Object authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public SecretBase credential() {
        return this.credential;
    }

    public InformixLinkedServiceTypeProperties withCredential(SecretBase credential) {
        this.credential = credential;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public InformixLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public InformixLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public InformixLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.connectionString() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionString in model InformixLinkedServiceTypeProperties"));
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("connectionString", this.connectionString);
        jsonWriter.writeUntypedField("authenticationType", this.authenticationType);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        jsonWriter.writeUntypedField("userName", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static InformixLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (InformixLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            InformixLinkedServiceTypeProperties deserializedInformixLinkedServiceTypeProperties = new InformixLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedInformixLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedInformixLinkedServiceTypeProperties.authenticationType = reader.readUntyped();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedInformixLinkedServiceTypeProperties.credential = SecretBase.fromJson(reader);
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedInformixLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedInformixLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedInformixLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInformixLinkedServiceTypeProperties;
        });
    }
}

