/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class HdfsLinkedServiceTypeProperties
implements JsonSerializable<HdfsLinkedServiceTypeProperties> {
    private Object url;
    private Object authenticationType;
    private String encryptedCredential;
    private Object username;
    private SecretBase password;
    private static final ClientLogger LOGGER = new ClientLogger(HdfsLinkedServiceTypeProperties.class);

    public Object url() {
        return this.url;
    }

    public HdfsLinkedServiceTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    public Object authenticationType() {
        return this.authenticationType;
    }

    public HdfsLinkedServiceTypeProperties withAuthenticationType(Object authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public HdfsLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public HdfsLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public HdfsLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public void validate() {
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model HdfsLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.url);
        jsonWriter.writeUntypedField("authenticationType", this.authenticationType);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeUntypedField("userName", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        return jsonWriter.writeEndObject();
    }

    public static HdfsLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HdfsLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            HdfsLinkedServiceTypeProperties deserializedHdfsLinkedServiceTypeProperties = new HdfsLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedHdfsLinkedServiceTypeProperties.url = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedHdfsLinkedServiceTypeProperties.authenticationType = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedHdfsLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedHdfsLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedHdfsLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHdfsLinkedServiceTypeProperties;
        });
    }
}

