/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class GoogleCloudStorageLinkedServiceTypeProperties
implements JsonSerializable<GoogleCloudStorageLinkedServiceTypeProperties> {
    private Object accessKeyId;
    private SecretBase secretAccessKey;
    private Object serviceUrl;
    private String encryptedCredential;

    public Object accessKeyId() {
        return this.accessKeyId;
    }

    public GoogleCloudStorageLinkedServiceTypeProperties withAccessKeyId(Object accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
    }

    public SecretBase secretAccessKey() {
        return this.secretAccessKey;
    }

    public GoogleCloudStorageLinkedServiceTypeProperties withSecretAccessKey(SecretBase secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
        return this;
    }

    public Object serviceUrl() {
        return this.serviceUrl;
    }

    public GoogleCloudStorageLinkedServiceTypeProperties withServiceUrl(Object serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public GoogleCloudStorageLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.secretAccessKey() != null) {
            this.secretAccessKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("accessKeyId", this.accessKeyId);
        jsonWriter.writeJsonField("secretAccessKey", (JsonSerializable)this.secretAccessKey);
        jsonWriter.writeUntypedField("serviceUrl", this.serviceUrl);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static GoogleCloudStorageLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GoogleCloudStorageLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            GoogleCloudStorageLinkedServiceTypeProperties deserializedGoogleCloudStorageLinkedServiceTypeProperties = new GoogleCloudStorageLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accessKeyId".equals(fieldName)) {
                    deserializedGoogleCloudStorageLinkedServiceTypeProperties.accessKeyId = reader.readUntyped();
                    continue;
                }
                if ("secretAccessKey".equals(fieldName)) {
                    deserializedGoogleCloudStorageLinkedServiceTypeProperties.secretAccessKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("serviceUrl".equals(fieldName)) {
                    deserializedGoogleCloudStorageLinkedServiceTypeProperties.serviceUrl = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedGoogleCloudStorageLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGoogleCloudStorageLinkedServiceTypeProperties;
        });
    }
}

