/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.GoogleBigQueryAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class GoogleBigQueryLinkedServiceTypeProperties
implements JsonSerializable<GoogleBigQueryLinkedServiceTypeProperties> {
    private Object project;
    private Object additionalProjects;
    private Object requestGoogleDriveScope;
    private GoogleBigQueryAuthenticationType authenticationType;
    private SecretBase refreshToken;
    private Object clientId;
    private SecretBase clientSecret;
    private Object email;
    private Object keyFilePath;
    private Object trustedCertPath;
    private Object useSystemTrustStore;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(GoogleBigQueryLinkedServiceTypeProperties.class);

    public Object project() {
        return this.project;
    }

    public GoogleBigQueryLinkedServiceTypeProperties withProject(Object project) {
        this.project = project;
        return this;
    }

    public Object additionalProjects() {
        return this.additionalProjects;
    }

    public GoogleBigQueryLinkedServiceTypeProperties withAdditionalProjects(Object additionalProjects) {
        this.additionalProjects = additionalProjects;
        return this;
    }

    public Object requestGoogleDriveScope() {
        return this.requestGoogleDriveScope;
    }

    public GoogleBigQueryLinkedServiceTypeProperties withRequestGoogleDriveScope(Object requestGoogleDriveScope) {
        this.requestGoogleDriveScope = requestGoogleDriveScope;
        return this;
    }

    public GoogleBigQueryAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public GoogleBigQueryLinkedServiceTypeProperties withAuthenticationType(GoogleBigQueryAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public SecretBase refreshToken() {
        return this.refreshToken;
    }

    public GoogleBigQueryLinkedServiceTypeProperties withRefreshToken(SecretBase refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public Object clientId() {
        return this.clientId;
    }

    public GoogleBigQueryLinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    public GoogleBigQueryLinkedServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object email() {
        return this.email;
    }

    public GoogleBigQueryLinkedServiceTypeProperties withEmail(Object email) {
        this.email = email;
        return this;
    }

    public Object keyFilePath() {
        return this.keyFilePath;
    }

    public GoogleBigQueryLinkedServiceTypeProperties withKeyFilePath(Object keyFilePath) {
        this.keyFilePath = keyFilePath;
        return this;
    }

    public Object trustedCertPath() {
        return this.trustedCertPath;
    }

    public GoogleBigQueryLinkedServiceTypeProperties withTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    public Object useSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public GoogleBigQueryLinkedServiceTypeProperties withUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public GoogleBigQueryLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.project() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property project in model GoogleBigQueryLinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model GoogleBigQueryLinkedServiceTypeProperties"));
        }
        if (this.refreshToken() != null) {
            this.refreshToken().validate();
        }
        if (this.clientSecret() != null) {
            this.clientSecret().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("project", this.project);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeUntypedField("additionalProjects", this.additionalProjects);
        jsonWriter.writeUntypedField("requestGoogleDriveScope", this.requestGoogleDriveScope);
        jsonWriter.writeJsonField("refreshToken", (JsonSerializable)this.refreshToken);
        jsonWriter.writeUntypedField("clientId", this.clientId);
        jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
        jsonWriter.writeUntypedField("email", this.email);
        jsonWriter.writeUntypedField("keyFilePath", this.keyFilePath);
        jsonWriter.writeUntypedField("trustedCertPath", this.trustedCertPath);
        jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static GoogleBigQueryLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GoogleBigQueryLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            GoogleBigQueryLinkedServiceTypeProperties deserializedGoogleBigQueryLinkedServiceTypeProperties = new GoogleBigQueryLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("project".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedServiceTypeProperties.project = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedServiceTypeProperties.authenticationType = GoogleBigQueryAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("additionalProjects".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedServiceTypeProperties.additionalProjects = reader.readUntyped();
                    continue;
                }
                if ("requestGoogleDriveScope".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedServiceTypeProperties.requestGoogleDriveScope = reader.readUntyped();
                    continue;
                }
                if ("refreshToken".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedServiceTypeProperties.refreshToken = SecretBase.fromJson(reader);
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedServiceTypeProperties.clientId = reader.readUntyped();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedServiceTypeProperties.clientSecret = SecretBase.fromJson(reader);
                    continue;
                }
                if ("email".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedServiceTypeProperties.email = reader.readUntyped();
                    continue;
                }
                if ("keyFilePath".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedServiceTypeProperties.keyFilePath = reader.readUntyped();
                    continue;
                }
                if ("trustedCertPath".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedServiceTypeProperties.trustedCertPath = reader.readUntyped();
                    continue;
                }
                if ("useSystemTrustStore".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedServiceTypeProperties.useSystemTrustStore = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGoogleBigQueryLinkedServiceTypeProperties;
        });
    }
}

