/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.SsisExecutionCredential;
import com.azure.resourcemanager.datafactory.models.SsisExecutionParameter;
import com.azure.resourcemanager.datafactory.models.SsisLogLocation;
import com.azure.resourcemanager.datafactory.models.SsisPackageLocation;
import com.azure.resourcemanager.datafactory.models.SsisPropertyOverride;
import java.io.IOException;
import java.util.Map;

public final class ExecuteSsisPackageActivityTypeProperties
implements JsonSerializable<ExecuteSsisPackageActivityTypeProperties> {
    private SsisPackageLocation packageLocation;
    private Object runtime;
    private Object loggingLevel;
    private Object environmentPath;
    private SsisExecutionCredential executionCredential;
    private IntegrationRuntimeReference connectVia;
    private Map<String, SsisExecutionParameter> projectParameters;
    private Map<String, SsisExecutionParameter> packageParameters;
    private Map<String, Map<String, SsisExecutionParameter>> projectConnectionManagers;
    private Map<String, Map<String, SsisExecutionParameter>> packageConnectionManagers;
    private Map<String, SsisPropertyOverride> propertyOverrides;
    private SsisLogLocation logLocation;
    private static final ClientLogger LOGGER = new ClientLogger(ExecuteSsisPackageActivityTypeProperties.class);

    public SsisPackageLocation packageLocation() {
        return this.packageLocation;
    }

    public ExecuteSsisPackageActivityTypeProperties withPackageLocation(SsisPackageLocation packageLocation) {
        this.packageLocation = packageLocation;
        return this;
    }

    public Object runtime() {
        return this.runtime;
    }

    public ExecuteSsisPackageActivityTypeProperties withRuntime(Object runtime) {
        this.runtime = runtime;
        return this;
    }

    public Object loggingLevel() {
        return this.loggingLevel;
    }

    public ExecuteSsisPackageActivityTypeProperties withLoggingLevel(Object loggingLevel) {
        this.loggingLevel = loggingLevel;
        return this;
    }

    public Object environmentPath() {
        return this.environmentPath;
    }

    public ExecuteSsisPackageActivityTypeProperties withEnvironmentPath(Object environmentPath) {
        this.environmentPath = environmentPath;
        return this;
    }

    public SsisExecutionCredential executionCredential() {
        return this.executionCredential;
    }

    public ExecuteSsisPackageActivityTypeProperties withExecutionCredential(SsisExecutionCredential executionCredential) {
        this.executionCredential = executionCredential;
        return this;
    }

    public IntegrationRuntimeReference connectVia() {
        return this.connectVia;
    }

    public ExecuteSsisPackageActivityTypeProperties withConnectVia(IntegrationRuntimeReference connectVia) {
        this.connectVia = connectVia;
        return this;
    }

    public Map<String, SsisExecutionParameter> projectParameters() {
        return this.projectParameters;
    }

    public ExecuteSsisPackageActivityTypeProperties withProjectParameters(Map<String, SsisExecutionParameter> projectParameters) {
        this.projectParameters = projectParameters;
        return this;
    }

    public Map<String, SsisExecutionParameter> packageParameters() {
        return this.packageParameters;
    }

    public ExecuteSsisPackageActivityTypeProperties withPackageParameters(Map<String, SsisExecutionParameter> packageParameters) {
        this.packageParameters = packageParameters;
        return this;
    }

    public Map<String, Map<String, SsisExecutionParameter>> projectConnectionManagers() {
        return this.projectConnectionManagers;
    }

    public ExecuteSsisPackageActivityTypeProperties withProjectConnectionManagers(Map<String, Map<String, SsisExecutionParameter>> projectConnectionManagers) {
        this.projectConnectionManagers = projectConnectionManagers;
        return this;
    }

    public Map<String, Map<String, SsisExecutionParameter>> packageConnectionManagers() {
        return this.packageConnectionManagers;
    }

    public ExecuteSsisPackageActivityTypeProperties withPackageConnectionManagers(Map<String, Map<String, SsisExecutionParameter>> packageConnectionManagers) {
        this.packageConnectionManagers = packageConnectionManagers;
        return this;
    }

    public Map<String, SsisPropertyOverride> propertyOverrides() {
        return this.propertyOverrides;
    }

    public ExecuteSsisPackageActivityTypeProperties withPropertyOverrides(Map<String, SsisPropertyOverride> propertyOverrides) {
        this.propertyOverrides = propertyOverrides;
        return this;
    }

    public SsisLogLocation logLocation() {
        return this.logLocation;
    }

    public ExecuteSsisPackageActivityTypeProperties withLogLocation(SsisLogLocation logLocation) {
        this.logLocation = logLocation;
        return this;
    }

    public void validate() {
        if (this.packageLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property packageLocation in model ExecuteSsisPackageActivityTypeProperties"));
        }
        this.packageLocation().validate();
        if (this.executionCredential() != null) {
            this.executionCredential().validate();
        }
        if (this.connectVia() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectVia in model ExecuteSsisPackageActivityTypeProperties"));
        }
        this.connectVia().validate();
        if (this.projectParameters() != null) {
            this.projectParameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.packageParameters() != null) {
            this.packageParameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.projectConnectionManagers() != null) {
            this.projectConnectionManagers().values().forEach(e -> {
                if (e != null) {
                    e.values().forEach(e1 -> {
                        if (e1 != null) {
                            e1.validate();
                        }
                    });
                }
            });
        }
        if (this.packageConnectionManagers() != null) {
            this.packageConnectionManagers().values().forEach(e -> {
                if (e != null) {
                    e.values().forEach(e1 -> {
                        if (e1 != null) {
                            e1.validate();
                        }
                    });
                }
            });
        }
        if (this.propertyOverrides() != null) {
            this.propertyOverrides().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.logLocation() != null) {
            this.logLocation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("packageLocation", (JsonSerializable)this.packageLocation);
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia);
        jsonWriter.writeUntypedField("runtime", this.runtime);
        jsonWriter.writeUntypedField("loggingLevel", this.loggingLevel);
        jsonWriter.writeUntypedField("environmentPath", this.environmentPath);
        jsonWriter.writeJsonField("executionCredential", (JsonSerializable)this.executionCredential);
        jsonWriter.writeMapField("projectParameters", this.projectParameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("packageParameters", this.packageParameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("projectConnectionManagers", this.projectConnectionManagers, (writer, element) -> writer.writeMap(element, (writer1, element1) -> writer1.writeJson((JsonSerializable)element1)));
        jsonWriter.writeMapField("packageConnectionManagers", this.packageConnectionManagers, (writer, element) -> writer.writeMap(element, (writer1, element1) -> writer1.writeJson((JsonSerializable)element1)));
        jsonWriter.writeMapField("propertyOverrides", this.propertyOverrides, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("logLocation", (JsonSerializable)this.logLocation);
        return jsonWriter.writeEndObject();
    }

    public static ExecuteSsisPackageActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExecuteSsisPackageActivityTypeProperties)jsonReader.readObject(reader -> {
            ExecuteSsisPackageActivityTypeProperties deserializedExecuteSsisPackageActivityTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("packageLocation".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivityTypeProperties.packageLocation = SsisPackageLocation.fromJson(reader);
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivityTypeProperties.connectVia = IntegrationRuntimeReference.fromJson(reader);
                    continue;
                }
                if ("runtime".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivityTypeProperties.runtime = reader.readUntyped();
                    continue;
                }
                if ("loggingLevel".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivityTypeProperties.loggingLevel = reader.readUntyped();
                    continue;
                }
                if ("environmentPath".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivityTypeProperties.environmentPath = reader.readUntyped();
                    continue;
                }
                if ("executionCredential".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivityTypeProperties.executionCredential = SsisExecutionCredential.fromJson(reader);
                    continue;
                }
                if ("projectParameters".equals(fieldName)) {
                    Map projectParameters;
                    deserializedExecuteSsisPackageActivityTypeProperties.projectParameters = projectParameters = reader.readMap(reader1 -> SsisExecutionParameter.fromJson(reader1));
                    continue;
                }
                if ("packageParameters".equals(fieldName)) {
                    Map packageParameters;
                    deserializedExecuteSsisPackageActivityTypeProperties.packageParameters = packageParameters = reader.readMap(reader1 -> SsisExecutionParameter.fromJson(reader1));
                    continue;
                }
                if ("projectConnectionManagers".equals(fieldName)) {
                    Map projectConnectionManagers;
                    deserializedExecuteSsisPackageActivityTypeProperties.projectConnectionManagers = projectConnectionManagers = reader.readMap(reader1 -> reader1.readMap(reader2 -> SsisExecutionParameter.fromJson(reader2)));
                    continue;
                }
                if ("packageConnectionManagers".equals(fieldName)) {
                    Map packageConnectionManagers;
                    deserializedExecuteSsisPackageActivityTypeProperties.packageConnectionManagers = packageConnectionManagers = reader.readMap(reader1 -> reader1.readMap(reader2 -> SsisExecutionParameter.fromJson(reader2)));
                    continue;
                }
                if ("propertyOverrides".equals(fieldName)) {
                    Map propertyOverrides;
                    deserializedExecuteSsisPackageActivityTypeProperties.propertyOverrides = propertyOverrides = reader.readMap(reader1 -> SsisPropertyOverride.fromJson(reader1));
                    continue;
                }
                if ("logLocation".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivityTypeProperties.logLocation = SsisLogLocation.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecuteSsisPackageActivityTypeProperties;
        });
    }
}

