/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ContinuationSettingsReference;
import com.azure.resourcemanager.datafactory.models.DataFlowReference;
import com.azure.resourcemanager.datafactory.models.DataFlowStagingInfo;
import com.azure.resourcemanager.datafactory.models.ExecuteDataFlowActivityTypePropertiesCompute;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import java.io.IOException;

public class ExecuteDataFlowActivityTypeProperties
implements JsonSerializable<ExecuteDataFlowActivityTypeProperties> {
    private DataFlowReference dataFlow;
    private DataFlowStagingInfo staging;
    private IntegrationRuntimeReference integrationRuntime;
    private ContinuationSettingsReference continuationSettings;
    private ExecuteDataFlowActivityTypePropertiesCompute compute;
    private Object traceLevel;
    private Object continueOnError;
    private Object runConcurrently;
    private Object sourceStagingConcurrency;
    private static final ClientLogger LOGGER = new ClientLogger(ExecuteDataFlowActivityTypeProperties.class);

    public DataFlowReference dataFlow() {
        return this.dataFlow;
    }

    public ExecuteDataFlowActivityTypeProperties withDataFlow(DataFlowReference dataFlow) {
        this.dataFlow = dataFlow;
        return this;
    }

    public DataFlowStagingInfo staging() {
        return this.staging;
    }

    public ExecuteDataFlowActivityTypeProperties withStaging(DataFlowStagingInfo staging) {
        this.staging = staging;
        return this;
    }

    public IntegrationRuntimeReference integrationRuntime() {
        return this.integrationRuntime;
    }

    public ExecuteDataFlowActivityTypeProperties withIntegrationRuntime(IntegrationRuntimeReference integrationRuntime) {
        this.integrationRuntime = integrationRuntime;
        return this;
    }

    public ContinuationSettingsReference continuationSettings() {
        return this.continuationSettings;
    }

    public ExecuteDataFlowActivityTypeProperties withContinuationSettings(ContinuationSettingsReference continuationSettings) {
        this.continuationSettings = continuationSettings;
        return this;
    }

    public ExecuteDataFlowActivityTypePropertiesCompute compute() {
        return this.compute;
    }

    public ExecuteDataFlowActivityTypeProperties withCompute(ExecuteDataFlowActivityTypePropertiesCompute compute) {
        this.compute = compute;
        return this;
    }

    public Object traceLevel() {
        return this.traceLevel;
    }

    public ExecuteDataFlowActivityTypeProperties withTraceLevel(Object traceLevel) {
        this.traceLevel = traceLevel;
        return this;
    }

    public Object continueOnError() {
        return this.continueOnError;
    }

    public ExecuteDataFlowActivityTypeProperties withContinueOnError(Object continueOnError) {
        this.continueOnError = continueOnError;
        return this;
    }

    public Object runConcurrently() {
        return this.runConcurrently;
    }

    public ExecuteDataFlowActivityTypeProperties withRunConcurrently(Object runConcurrently) {
        this.runConcurrently = runConcurrently;
        return this;
    }

    public Object sourceStagingConcurrency() {
        return this.sourceStagingConcurrency;
    }

    public ExecuteDataFlowActivityTypeProperties withSourceStagingConcurrency(Object sourceStagingConcurrency) {
        this.sourceStagingConcurrency = sourceStagingConcurrency;
        return this;
    }

    public void validate() {
        if (this.dataFlow() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataFlow in model ExecuteDataFlowActivityTypeProperties"));
        }
        this.dataFlow().validate();
        if (this.staging() != null) {
            this.staging().validate();
        }
        if (this.integrationRuntime() != null) {
            this.integrationRuntime().validate();
        }
        if (this.continuationSettings() != null) {
            this.continuationSettings().validate();
        }
        if (this.compute() != null) {
            this.compute().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dataFlow", (JsonSerializable)this.dataFlow);
        jsonWriter.writeJsonField("staging", (JsonSerializable)this.staging);
        jsonWriter.writeJsonField("integrationRuntime", (JsonSerializable)this.integrationRuntime);
        jsonWriter.writeJsonField("continuationSettings", (JsonSerializable)this.continuationSettings);
        jsonWriter.writeJsonField("compute", (JsonSerializable)this.compute);
        jsonWriter.writeUntypedField("traceLevel", this.traceLevel);
        jsonWriter.writeUntypedField("continueOnError", this.continueOnError);
        jsonWriter.writeUntypedField("runConcurrently", this.runConcurrently);
        jsonWriter.writeUntypedField("sourceStagingConcurrency", this.sourceStagingConcurrency);
        return jsonWriter.writeEndObject();
    }

    public static ExecuteDataFlowActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExecuteDataFlowActivityTypeProperties)jsonReader.readObject(reader -> {
            ExecuteDataFlowActivityTypeProperties deserializedExecuteDataFlowActivityTypeProperties = new ExecuteDataFlowActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataFlow".equals(fieldName)) {
                    deserializedExecuteDataFlowActivityTypeProperties.dataFlow = DataFlowReference.fromJson(reader);
                    continue;
                }
                if ("staging".equals(fieldName)) {
                    deserializedExecuteDataFlowActivityTypeProperties.staging = DataFlowStagingInfo.fromJson(reader);
                    continue;
                }
                if ("integrationRuntime".equals(fieldName)) {
                    deserializedExecuteDataFlowActivityTypeProperties.integrationRuntime = IntegrationRuntimeReference.fromJson(reader);
                    continue;
                }
                if ("continuationSettings".equals(fieldName)) {
                    deserializedExecuteDataFlowActivityTypeProperties.continuationSettings = ContinuationSettingsReference.fromJson(reader);
                    continue;
                }
                if ("compute".equals(fieldName)) {
                    deserializedExecuteDataFlowActivityTypeProperties.compute = ExecuteDataFlowActivityTypePropertiesCompute.fromJson(reader);
                    continue;
                }
                if ("traceLevel".equals(fieldName)) {
                    deserializedExecuteDataFlowActivityTypeProperties.traceLevel = reader.readUntyped();
                    continue;
                }
                if ("continueOnError".equals(fieldName)) {
                    deserializedExecuteDataFlowActivityTypeProperties.continueOnError = reader.readUntyped();
                    continue;
                }
                if ("runConcurrently".equals(fieldName)) {
                    deserializedExecuteDataFlowActivityTypeProperties.runConcurrently = reader.readUntyped();
                    continue;
                }
                if ("sourceStagingConcurrency".equals(fieldName)) {
                    deserializedExecuteDataFlowActivityTypeProperties.sourceStagingConcurrency = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecuteDataFlowActivityTypeProperties;
        });
    }
}

