/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import java.io.IOException;

public final class DrillLinkedServiceTypeProperties
implements JsonSerializable<DrillLinkedServiceTypeProperties> {
    private Object connectionString;
    private AzureKeyVaultSecretReference pwd;
    private String encryptedCredential;

    public Object connectionString() {
        return this.connectionString;
    }

    public DrillLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureKeyVaultSecretReference pwd() {
        return this.pwd;
    }

    public DrillLinkedServiceTypeProperties withPwd(AzureKeyVaultSecretReference pwd) {
        this.pwd = pwd;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public DrillLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.pwd() != null) {
            this.pwd().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("connectionString", this.connectionString);
        jsonWriter.writeJsonField("pwd", (JsonSerializable)this.pwd);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static DrillLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DrillLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            DrillLinkedServiceTypeProperties deserializedDrillLinkedServiceTypeProperties = new DrillLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedDrillLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("pwd".equals(fieldName)) {
                    deserializedDrillLinkedServiceTypeProperties.pwd = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedDrillLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDrillLinkedServiceTypeProperties;
        });
    }
}

