/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CosmosDbConnectionMode;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class CosmosDbLinkedServiceTypeProperties
implements JsonSerializable<CosmosDbLinkedServiceTypeProperties> {
    private Object connectionString;
    private Object accountEndpoint;
    private Object database;
    private SecretBase accountKey;
    private Object servicePrincipalId;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalCredential;
    private Object tenant;
    private Object azureCloudType;
    private CosmosDbConnectionMode connectionMode;
    private String encryptedCredential;
    private CredentialReference credential;

    public Object connectionString() {
        return this.connectionString;
    }

    public CosmosDbLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object accountEndpoint() {
        return this.accountEndpoint;
    }

    public CosmosDbLinkedServiceTypeProperties withAccountEndpoint(Object accountEndpoint) {
        this.accountEndpoint = accountEndpoint;
        return this;
    }

    public Object database() {
        return this.database;
    }

    public CosmosDbLinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    public SecretBase accountKey() {
        return this.accountKey;
    }

    public CosmosDbLinkedServiceTypeProperties withAccountKey(SecretBase accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public CosmosDbLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public Object servicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public CosmosDbLinkedServiceTypeProperties withServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase servicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    public CosmosDbLinkedServiceTypeProperties withServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public CosmosDbLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object azureCloudType() {
        return this.azureCloudType;
    }

    public CosmosDbLinkedServiceTypeProperties withAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public CosmosDbConnectionMode connectionMode() {
        return this.connectionMode;
    }

    public CosmosDbLinkedServiceTypeProperties withConnectionMode(CosmosDbConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public CosmosDbLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public CosmosDbLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public void validate() {
        if (this.accountKey() != null) {
            this.accountKey().validate();
        }
        if (this.servicePrincipalCredential() != null) {
            this.servicePrincipalCredential().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("connectionString", this.connectionString);
        jsonWriter.writeUntypedField("accountEndpoint", this.accountEndpoint);
        jsonWriter.writeUntypedField("database", this.database);
        jsonWriter.writeJsonField("accountKey", (JsonSerializable)this.accountKey);
        jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
        jsonWriter.writeJsonField("servicePrincipalCredential", (JsonSerializable)this.servicePrincipalCredential);
        jsonWriter.writeUntypedField("tenant", this.tenant);
        jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
        jsonWriter.writeStringField("connectionMode", this.connectionMode == null ? null : this.connectionMode.toString());
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static CosmosDbLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CosmosDbLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            CosmosDbLinkedServiceTypeProperties deserializedCosmosDbLinkedServiceTypeProperties = new CosmosDbLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedCosmosDbLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("accountEndpoint".equals(fieldName)) {
                    deserializedCosmosDbLinkedServiceTypeProperties.accountEndpoint = reader.readUntyped();
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedCosmosDbLinkedServiceTypeProperties.database = reader.readUntyped();
                    continue;
                }
                if ("accountKey".equals(fieldName)) {
                    deserializedCosmosDbLinkedServiceTypeProperties.accountKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedCosmosDbLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalCredentialType".equals(fieldName)) {
                    deserializedCosmosDbLinkedServiceTypeProperties.servicePrincipalCredentialType = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalCredential".equals(fieldName)) {
                    deserializedCosmosDbLinkedServiceTypeProperties.servicePrincipalCredential = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedCosmosDbLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("azureCloudType".equals(fieldName)) {
                    deserializedCosmosDbLinkedServiceTypeProperties.azureCloudType = reader.readUntyped();
                    continue;
                }
                if ("connectionMode".equals(fieldName)) {
                    deserializedCosmosDbLinkedServiceTypeProperties.connectionMode = CosmosDbConnectionMode.fromString(reader.getString());
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedCosmosDbLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedCosmosDbLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCosmosDbLinkedServiceTypeProperties;
        });
    }
}

