/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class ConcurLinkedServiceTypeProperties
implements JsonSerializable<ConcurLinkedServiceTypeProperties> {
    private Object connectionProperties;
    private Object clientId;
    private Object username;
    private SecretBase password;
    private Object useEncryptedEndpoints;
    private Object useHostVerification;
    private Object usePeerVerification;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(ConcurLinkedServiceTypeProperties.class);

    public Object connectionProperties() {
        return this.connectionProperties;
    }

    public ConcurLinkedServiceTypeProperties withConnectionProperties(Object connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    public Object clientId() {
        return this.clientId;
    }

    public ConcurLinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public ConcurLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public ConcurLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object useEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public ConcurLinkedServiceTypeProperties withUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object useHostVerification() {
        return this.useHostVerification;
    }

    public ConcurLinkedServiceTypeProperties withUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    public Object usePeerVerification() {
        return this.usePeerVerification;
    }

    public ConcurLinkedServiceTypeProperties withUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public ConcurLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.clientId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clientId in model ConcurLinkedServiceTypeProperties"));
        }
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model ConcurLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("clientId", this.clientId);
        jsonWriter.writeUntypedField("username", this.username);
        jsonWriter.writeUntypedField("connectionProperties", this.connectionProperties);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
        jsonWriter.writeUntypedField("useHostVerification", this.useHostVerification);
        jsonWriter.writeUntypedField("usePeerVerification", this.usePeerVerification);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static ConcurLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConcurLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            ConcurLinkedServiceTypeProperties deserializedConcurLinkedServiceTypeProperties = new ConcurLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clientId".equals(fieldName)) {
                    deserializedConcurLinkedServiceTypeProperties.clientId = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedConcurLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("connectionProperties".equals(fieldName)) {
                    deserializedConcurLinkedServiceTypeProperties.connectionProperties = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedConcurLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("useEncryptedEndpoints".equals(fieldName)) {
                    deserializedConcurLinkedServiceTypeProperties.useEncryptedEndpoints = reader.readUntyped();
                    continue;
                }
                if ("useHostVerification".equals(fieldName)) {
                    deserializedConcurLinkedServiceTypeProperties.useHostVerification = reader.readUntyped();
                    continue;
                }
                if ("usePeerVerification".equals(fieldName)) {
                    deserializedConcurLinkedServiceTypeProperties.usePeerVerification = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedConcurLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConcurLinkedServiceTypeProperties;
        });
    }
}

