/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.AzureSqlDWAuthenticationType;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SqlServerBaseLinkedServiceTypeProperties;
import java.io.IOException;

public final class AzureSqlDWLinkedServiceTypeProperties
extends SqlServerBaseLinkedServiceTypeProperties {
    private Object connectionString;
    private AzureSqlDWAuthenticationType authenticationType;
    private Object username;
    private AzureKeyVaultSecretReference password;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalCredential;
    private Object tenant;
    private Object azureCloudType;
    private String encryptedCredential;
    private CredentialReference credential;

    public Object connectionString() {
        return this.connectionString;
    }

    public AzureSqlDWLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureSqlDWAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public AzureSqlDWLinkedServiceTypeProperties withAuthenticationType(AzureSqlDWAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public AzureSqlDWLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public AzureKeyVaultSecretReference password() {
        return this.password;
    }

    public AzureSqlDWLinkedServiceTypeProperties withPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureSqlDWLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureSqlDWLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object servicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public AzureSqlDWLinkedServiceTypeProperties withServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase servicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    public AzureSqlDWLinkedServiceTypeProperties withServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public AzureSqlDWLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object azureCloudType() {
        return this.azureCloudType;
    }

    public AzureSqlDWLinkedServiceTypeProperties withAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureSqlDWLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public AzureSqlDWLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withServer(Object server) {
        super.withServer(server);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withDatabase(Object database) {
        super.withDatabase(database);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withEncrypt(Object encrypt) {
        super.withEncrypt(encrypt);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withTrustServerCertificate(Object trustServerCertificate) {
        super.withTrustServerCertificate(trustServerCertificate);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withHostnameInCertificate(Object hostnameInCertificate) {
        super.withHostnameInCertificate(hostnameInCertificate);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withApplicationIntent(Object applicationIntent) {
        super.withApplicationIntent(applicationIntent);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withConnectTimeout(Object connectTimeout) {
        super.withConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withConnectRetryCount(Object connectRetryCount) {
        super.withConnectRetryCount(connectRetryCount);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withConnectRetryInterval(Object connectRetryInterval) {
        super.withConnectRetryInterval(connectRetryInterval);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withLoadBalanceTimeout(Object loadBalanceTimeout) {
        super.withLoadBalanceTimeout(loadBalanceTimeout);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withCommandTimeout(Object commandTimeout) {
        super.withCommandTimeout(commandTimeout);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withIntegratedSecurity(Object integratedSecurity) {
        super.withIntegratedSecurity(integratedSecurity);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withFailoverPartner(Object failoverPartner) {
        super.withFailoverPartner(failoverPartner);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withMaxPoolSize(Object maxPoolSize) {
        super.withMaxPoolSize(maxPoolSize);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withMinPoolSize(Object minPoolSize) {
        super.withMinPoolSize(minPoolSize);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withMultipleActiveResultSets(Object multipleActiveResultSets) {
        super.withMultipleActiveResultSets(multipleActiveResultSets);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withMultiSubnetFailover(Object multiSubnetFailover) {
        super.withMultiSubnetFailover(multiSubnetFailover);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withPacketSize(Object packetSize) {
        super.withPacketSize(packetSize);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties withPooling(Object pooling) {
        super.withPooling(pooling);
        return this;
    }

    @Override
    public void validate() {
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
        if (this.servicePrincipalCredential() != null) {
            this.servicePrincipalCredential().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("server", this.server());
        jsonWriter.writeUntypedField("database", this.database());
        jsonWriter.writeUntypedField("encrypt", this.encrypt());
        jsonWriter.writeUntypedField("trustServerCertificate", this.trustServerCertificate());
        jsonWriter.writeUntypedField("hostNameInCertificate", this.hostnameInCertificate());
        jsonWriter.writeUntypedField("applicationIntent", this.applicationIntent());
        jsonWriter.writeUntypedField("connectTimeout", this.connectTimeout());
        jsonWriter.writeUntypedField("connectRetryCount", this.connectRetryCount());
        jsonWriter.writeUntypedField("connectRetryInterval", this.connectRetryInterval());
        jsonWriter.writeUntypedField("loadBalanceTimeout", this.loadBalanceTimeout());
        jsonWriter.writeUntypedField("commandTimeout", this.commandTimeout());
        jsonWriter.writeUntypedField("integratedSecurity", this.integratedSecurity());
        jsonWriter.writeUntypedField("failoverPartner", this.failoverPartner());
        jsonWriter.writeUntypedField("maxPoolSize", this.maxPoolSize());
        jsonWriter.writeUntypedField("minPoolSize", this.minPoolSize());
        jsonWriter.writeUntypedField("multipleActiveResultSets", this.multipleActiveResultSets());
        jsonWriter.writeUntypedField("multiSubnetFailover", this.multiSubnetFailover());
        jsonWriter.writeUntypedField("packetSize", this.packetSize());
        jsonWriter.writeUntypedField("pooling", this.pooling());
        jsonWriter.writeUntypedField("connectionString", this.connectionString);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeUntypedField("userName", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
        jsonWriter.writeJsonField("servicePrincipalCredential", (JsonSerializable)this.servicePrincipalCredential);
        jsonWriter.writeUntypedField("tenant", this.tenant);
        jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static AzureSqlDWLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSqlDWLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureSqlDWLinkedServiceTypeProperties deserializedAzureSqlDWLinkedServiceTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withServer(reader.readUntyped());
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withDatabase(reader.readUntyped());
                    continue;
                }
                if ("encrypt".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withEncrypt(reader.readUntyped());
                    continue;
                }
                if ("trustServerCertificate".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withTrustServerCertificate(reader.readUntyped());
                    continue;
                }
                if ("hostNameInCertificate".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withHostnameInCertificate(reader.readUntyped());
                    continue;
                }
                if ("applicationIntent".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withApplicationIntent(reader.readUntyped());
                    continue;
                }
                if ("connectTimeout".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withConnectTimeout(reader.readUntyped());
                    continue;
                }
                if ("connectRetryCount".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withConnectRetryCount(reader.readUntyped());
                    continue;
                }
                if ("connectRetryInterval".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withConnectRetryInterval(reader.readUntyped());
                    continue;
                }
                if ("loadBalanceTimeout".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withLoadBalanceTimeout(reader.readUntyped());
                    continue;
                }
                if ("commandTimeout".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withCommandTimeout(reader.readUntyped());
                    continue;
                }
                if ("integratedSecurity".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withIntegratedSecurity(reader.readUntyped());
                    continue;
                }
                if ("failoverPartner".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withFailoverPartner(reader.readUntyped());
                    continue;
                }
                if ("maxPoolSize".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withMaxPoolSize(reader.readUntyped());
                    continue;
                }
                if ("minPoolSize".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withMinPoolSize(reader.readUntyped());
                    continue;
                }
                if ("multipleActiveResultSets".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withMultipleActiveResultSets(reader.readUntyped());
                    continue;
                }
                if ("multiSubnetFailover".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withMultiSubnetFailover(reader.readUntyped());
                    continue;
                }
                if ("packetSize".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withPacketSize(reader.readUntyped());
                    continue;
                }
                if ("pooling".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.withPooling(reader.readUntyped());
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.authenticationType = AzureSqlDWAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.password = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalCredentialType".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.servicePrincipalCredentialType = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalCredential".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.servicePrincipalCredential = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("azureCloudType".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.azureCloudType = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureSqlDWLinkedServiceTypeProperties;
        });
    }
}

