/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AzureMLLinkedServiceTypeProperties
implements JsonSerializable<AzureMLLinkedServiceTypeProperties> {
    private Object mlEndpoint;
    private SecretBase apiKey;
    private Object updateResourceEndpoint;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private String encryptedCredential;
    private Object authentication;
    private static final ClientLogger LOGGER = new ClientLogger(AzureMLLinkedServiceTypeProperties.class);

    public Object mlEndpoint() {
        return this.mlEndpoint;
    }

    public AzureMLLinkedServiceTypeProperties withMlEndpoint(Object mlEndpoint) {
        this.mlEndpoint = mlEndpoint;
        return this;
    }

    public SecretBase apiKey() {
        return this.apiKey;
    }

    public AzureMLLinkedServiceTypeProperties withApiKey(SecretBase apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public Object updateResourceEndpoint() {
        return this.updateResourceEndpoint;
    }

    public AzureMLLinkedServiceTypeProperties withUpdateResourceEndpoint(Object updateResourceEndpoint) {
        this.updateResourceEndpoint = updateResourceEndpoint;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureMLLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureMLLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public AzureMLLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureMLLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object authentication() {
        return this.authentication;
    }

    public AzureMLLinkedServiceTypeProperties withAuthentication(Object authentication) {
        this.authentication = authentication;
        return this;
    }

    public void validate() {
        if (this.mlEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property mlEndpoint in model AzureMLLinkedServiceTypeProperties"));
        }
        if (this.apiKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property apiKey in model AzureMLLinkedServiceTypeProperties"));
        }
        this.apiKey().validate();
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("mlEndpoint", this.mlEndpoint);
        jsonWriter.writeJsonField("apiKey", (JsonSerializable)this.apiKey);
        jsonWriter.writeUntypedField("updateResourceEndpoint", this.updateResourceEndpoint);
        jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        jsonWriter.writeUntypedField("tenant", this.tenant);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeUntypedField("authentication", this.authentication);
        return jsonWriter.writeEndObject();
    }

    public static AzureMLLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMLLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureMLLinkedServiceTypeProperties deserializedAzureMLLinkedServiceTypeProperties = new AzureMLLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mlEndpoint".equals(fieldName)) {
                    deserializedAzureMLLinkedServiceTypeProperties.mlEndpoint = reader.readUntyped();
                    continue;
                }
                if ("apiKey".equals(fieldName)) {
                    deserializedAzureMLLinkedServiceTypeProperties.apiKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("updateResourceEndpoint".equals(fieldName)) {
                    deserializedAzureMLLinkedServiceTypeProperties.updateResourceEndpoint = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedAzureMLLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedAzureMLLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedAzureMLLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureMLLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    deserializedAzureMLLinkedServiceTypeProperties.authentication = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureMLLinkedServiceTypeProperties;
        });
    }
}

