/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AzureDataExplorerLinkedServiceTypeProperties
implements JsonSerializable<AzureDataExplorerLinkedServiceTypeProperties> {
    private Object endpoint;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object database;
    private Object tenant;
    private CredentialReference credential;
    private static final ClientLogger LOGGER = new ClientLogger(AzureDataExplorerLinkedServiceTypeProperties.class);

    public Object endpoint() {
        return this.endpoint;
    }

    public AzureDataExplorerLinkedServiceTypeProperties withEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureDataExplorerLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureDataExplorerLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object database() {
        return this.database;
    }

    public AzureDataExplorerLinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public AzureDataExplorerLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public AzureDataExplorerLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public void validate() {
        if (this.endpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endpoint in model AzureDataExplorerLinkedServiceTypeProperties"));
        }
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
        if (this.database() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property database in model AzureDataExplorerLinkedServiceTypeProperties"));
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("endpoint", this.endpoint);
        jsonWriter.writeUntypedField("database", this.database);
        jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        jsonWriter.writeUntypedField("tenant", this.tenant);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static AzureDataExplorerLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDataExplorerLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureDataExplorerLinkedServiceTypeProperties deserializedAzureDataExplorerLinkedServiceTypeProperties = new AzureDataExplorerLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoint".equals(fieldName)) {
                    deserializedAzureDataExplorerLinkedServiceTypeProperties.endpoint = reader.readUntyped();
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedAzureDataExplorerLinkedServiceTypeProperties.database = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedAzureDataExplorerLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedAzureDataExplorerLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedAzureDataExplorerLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureDataExplorerLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureDataExplorerLinkedServiceTypeProperties;
        });
    }
}

