/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetStorageFormat;
import java.io.IOException;

public final class AzureBlobFSDatasetTypeProperties
implements JsonSerializable<AzureBlobFSDatasetTypeProperties> {
    private Object folderPath;
    private Object fileName;
    private DatasetStorageFormat format;
    private DatasetCompression compression;

    public Object folderPath() {
        return this.folderPath;
    }

    public AzureBlobFSDatasetTypeProperties withFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public Object fileName() {
        return this.fileName;
    }

    public AzureBlobFSDatasetTypeProperties withFileName(Object fileName) {
        this.fileName = fileName;
        return this;
    }

    public DatasetStorageFormat format() {
        return this.format;
    }

    public AzureBlobFSDatasetTypeProperties withFormat(DatasetStorageFormat format) {
        this.format = format;
        return this;
    }

    public DatasetCompression compression() {
        return this.compression;
    }

    public AzureBlobFSDatasetTypeProperties withCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    public void validate() {
        if (this.format() != null) {
            this.format().validate();
        }
        if (this.compression() != null) {
            this.compression().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("folderPath", this.folderPath);
        jsonWriter.writeUntypedField("fileName", this.fileName);
        jsonWriter.writeJsonField("format", (JsonSerializable)this.format);
        jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobFSDatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobFSDatasetTypeProperties)jsonReader.readObject(reader -> {
            AzureBlobFSDatasetTypeProperties deserializedAzureBlobFSDatasetTypeProperties = new AzureBlobFSDatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("folderPath".equals(fieldName)) {
                    deserializedAzureBlobFSDatasetTypeProperties.folderPath = reader.readUntyped();
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedAzureBlobFSDatasetTypeProperties.fileName = reader.readUntyped();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedAzureBlobFSDatasetTypeProperties.format = DatasetStorageFormat.fromJson(reader);
                    continue;
                }
                if ("compression".equals(fieldName)) {
                    deserializedAzureBlobFSDatasetTypeProperties.compression = DatasetCompression.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBlobFSDatasetTypeProperties;
        });
    }
}

