/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AmazonRdsForSqlAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SqlAlwaysEncryptedProperties;
import com.azure.resourcemanager.datafactory.models.SqlServerBaseLinkedServiceTypeProperties;
import java.io.IOException;

public final class AmazonRdsForSqlServerLinkedServiceTypeProperties
extends SqlServerBaseLinkedServiceTypeProperties {
    private Object connectionString;
    private AmazonRdsForSqlAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private String encryptedCredential;
    private SqlAlwaysEncryptedProperties alwaysEncryptedSettings;

    public Object connectionString() {
        return this.connectionString;
    }

    public AmazonRdsForSqlServerLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AmazonRdsForSqlAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public AmazonRdsForSqlServerLinkedServiceTypeProperties withAuthenticationType(AmazonRdsForSqlAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public AmazonRdsForSqlServerLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public AmazonRdsForSqlServerLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AmazonRdsForSqlServerLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public SqlAlwaysEncryptedProperties alwaysEncryptedSettings() {
        return this.alwaysEncryptedSettings;
    }

    public AmazonRdsForSqlServerLinkedServiceTypeProperties withAlwaysEncryptedSettings(SqlAlwaysEncryptedProperties alwaysEncryptedSettings) {
        this.alwaysEncryptedSettings = alwaysEncryptedSettings;
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withServer(Object server) {
        super.withServer(server);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withDatabase(Object database) {
        super.withDatabase(database);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withEncrypt(Object encrypt) {
        super.withEncrypt(encrypt);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withTrustServerCertificate(Object trustServerCertificate) {
        super.withTrustServerCertificate(trustServerCertificate);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withHostnameInCertificate(Object hostnameInCertificate) {
        super.withHostnameInCertificate(hostnameInCertificate);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withApplicationIntent(Object applicationIntent) {
        super.withApplicationIntent(applicationIntent);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withConnectTimeout(Object connectTimeout) {
        super.withConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withConnectRetryCount(Object connectRetryCount) {
        super.withConnectRetryCount(connectRetryCount);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withConnectRetryInterval(Object connectRetryInterval) {
        super.withConnectRetryInterval(connectRetryInterval);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withLoadBalanceTimeout(Object loadBalanceTimeout) {
        super.withLoadBalanceTimeout(loadBalanceTimeout);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withCommandTimeout(Object commandTimeout) {
        super.withCommandTimeout(commandTimeout);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withIntegratedSecurity(Object integratedSecurity) {
        super.withIntegratedSecurity(integratedSecurity);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withFailoverPartner(Object failoverPartner) {
        super.withFailoverPartner(failoverPartner);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withMaxPoolSize(Object maxPoolSize) {
        super.withMaxPoolSize(maxPoolSize);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withMinPoolSize(Object minPoolSize) {
        super.withMinPoolSize(minPoolSize);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withMultipleActiveResultSets(Object multipleActiveResultSets) {
        super.withMultipleActiveResultSets(multipleActiveResultSets);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withMultiSubnetFailover(Object multiSubnetFailover) {
        super.withMultiSubnetFailover(multiSubnetFailover);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withPacketSize(Object packetSize) {
        super.withPacketSize(packetSize);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withPooling(Object pooling) {
        super.withPooling(pooling);
        return this;
    }

    @Override
    public void validate() {
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.alwaysEncryptedSettings() != null) {
            this.alwaysEncryptedSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("server", this.server());
        jsonWriter.writeUntypedField("database", this.database());
        jsonWriter.writeUntypedField("encrypt", this.encrypt());
        jsonWriter.writeUntypedField("trustServerCertificate", this.trustServerCertificate());
        jsonWriter.writeUntypedField("hostNameInCertificate", this.hostnameInCertificate());
        jsonWriter.writeUntypedField("applicationIntent", this.applicationIntent());
        jsonWriter.writeUntypedField("connectTimeout", this.connectTimeout());
        jsonWriter.writeUntypedField("connectRetryCount", this.connectRetryCount());
        jsonWriter.writeUntypedField("connectRetryInterval", this.connectRetryInterval());
        jsonWriter.writeUntypedField("loadBalanceTimeout", this.loadBalanceTimeout());
        jsonWriter.writeUntypedField("commandTimeout", this.commandTimeout());
        jsonWriter.writeUntypedField("integratedSecurity", this.integratedSecurity());
        jsonWriter.writeUntypedField("failoverPartner", this.failoverPartner());
        jsonWriter.writeUntypedField("maxPoolSize", this.maxPoolSize());
        jsonWriter.writeUntypedField("minPoolSize", this.minPoolSize());
        jsonWriter.writeUntypedField("multipleActiveResultSets", this.multipleActiveResultSets());
        jsonWriter.writeUntypedField("multiSubnetFailover", this.multiSubnetFailover());
        jsonWriter.writeUntypedField("packetSize", this.packetSize());
        jsonWriter.writeUntypedField("pooling", this.pooling());
        jsonWriter.writeUntypedField("connectionString", this.connectionString);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeUntypedField("userName", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeJsonField("alwaysEncryptedSettings", (JsonSerializable)this.alwaysEncryptedSettings);
        return jsonWriter.writeEndObject();
    }

    public static AmazonRdsForSqlServerLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonRdsForSqlServerLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AmazonRdsForSqlServerLinkedServiceTypeProperties deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withServer(reader.readUntyped());
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withDatabase(reader.readUntyped());
                    continue;
                }
                if ("encrypt".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withEncrypt(reader.readUntyped());
                    continue;
                }
                if ("trustServerCertificate".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withTrustServerCertificate(reader.readUntyped());
                    continue;
                }
                if ("hostNameInCertificate".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withHostnameInCertificate(reader.readUntyped());
                    continue;
                }
                if ("applicationIntent".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withApplicationIntent(reader.readUntyped());
                    continue;
                }
                if ("connectTimeout".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withConnectTimeout(reader.readUntyped());
                    continue;
                }
                if ("connectRetryCount".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withConnectRetryCount(reader.readUntyped());
                    continue;
                }
                if ("connectRetryInterval".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withConnectRetryInterval(reader.readUntyped());
                    continue;
                }
                if ("loadBalanceTimeout".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withLoadBalanceTimeout(reader.readUntyped());
                    continue;
                }
                if ("commandTimeout".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withCommandTimeout(reader.readUntyped());
                    continue;
                }
                if ("integratedSecurity".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withIntegratedSecurity(reader.readUntyped());
                    continue;
                }
                if ("failoverPartner".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withFailoverPartner(reader.readUntyped());
                    continue;
                }
                if ("maxPoolSize".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withMaxPoolSize(reader.readUntyped());
                    continue;
                }
                if ("minPoolSize".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withMinPoolSize(reader.readUntyped());
                    continue;
                }
                if ("multipleActiveResultSets".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withMultipleActiveResultSets(reader.readUntyped());
                    continue;
                }
                if ("multiSubnetFailover".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withMultiSubnetFailover(reader.readUntyped());
                    continue;
                }
                if ("packetSize".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withPacketSize(reader.readUntyped());
                    continue;
                }
                if ("pooling".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.withPooling(reader.readUntyped());
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.authenticationType = AmazonRdsForSqlAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("alwaysEncryptedSettings".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties.alwaysEncryptedSettings = SqlAlwaysEncryptedProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAmazonRdsForSqlServerLinkedServiceTypeProperties;
        });
    }
}

