/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AmazonRdsForLinkedServiceTypeProperties
implements JsonSerializable<AmazonRdsForLinkedServiceTypeProperties> {
    private Object connectionString;
    private SecretBase password;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(AmazonRdsForLinkedServiceTypeProperties.class);

    public Object connectionString() {
        return this.connectionString;
    }

    public AmazonRdsForLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public AmazonRdsForLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AmazonRdsForLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.connectionString() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionString in model AmazonRdsForLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("connectionString", this.connectionString);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static AmazonRdsForLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonRdsForLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AmazonRdsForLinkedServiceTypeProperties deserializedAmazonRdsForLinkedServiceTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedAmazonRdsForLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedAmazonRdsForLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAmazonRdsForLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAmazonRdsForLinkedServiceTypeProperties;
        });
    }
}

