/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.CreateJobValidations;
import com.azure.resourcemanager.databox.models.ValidationInputRequest;
import java.io.IOException;
import java.util.List;

public class ValidationRequest
implements JsonSerializable<ValidationRequest> {
    private String validationCategory = "ValidationRequest";
    private List<ValidationInputRequest> individualRequestDetails;
    private static final ClientLogger LOGGER = new ClientLogger(ValidationRequest.class);

    public String validationCategory() {
        return this.validationCategory;
    }

    public List<ValidationInputRequest> individualRequestDetails() {
        return this.individualRequestDetails;
    }

    public ValidationRequest withIndividualRequestDetails(List<ValidationInputRequest> individualRequestDetails) {
        this.individualRequestDetails = individualRequestDetails;
        return this;
    }

    public void validate() {
        if (this.individualRequestDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property individualRequestDetails in model ValidationRequest"));
        }
        this.individualRequestDetails().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("individualRequestDetails", this.individualRequestDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("validationCategory", this.validationCategory);
        return jsonWriter.writeEndObject();
    }

    public static ValidationRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ValidationRequest)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ValidationRequest validationRequest;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("validationCategory".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("JobCreationValidation".equals(discriminatorValue)) {
                    validationRequest = CreateJobValidations.fromJson(readerToUse.reset());
                    return validationRequest;
                }
                validationRequest = ValidationRequest.fromJsonKnownDiscriminator(readerToUse.reset());
                return validationRequest;
            }
        });
    }

    static ValidationRequest fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ValidationRequest)jsonReader.readObject(reader -> {
            ValidationRequest deserializedValidationRequest = new ValidationRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("individualRequestDetails".equals(fieldName)) {
                    List individualRequestDetails;
                    deserializedValidationRequest.individualRequestDetails = individualRequestDetails = reader.readArray(reader1 -> ValidationInputRequest.fromJson(reader1));
                    continue;
                }
                if ("validationCategory".equals(fieldName)) {
                    deserializedValidationRequest.validationCategory = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidationRequest;
        });
    }
}

