/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.AddressValidationProperties;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.CreateOrderLimitForSubscriptionValidationResponseProperties;
import com.azure.resourcemanager.databox.models.DataTransferDetailsValidationResponseProperties;
import com.azure.resourcemanager.databox.models.PreferencesValidationResponseProperties;
import com.azure.resourcemanager.databox.models.SkuAvailabilityValidationResponseProperties;
import com.azure.resourcemanager.databox.models.SubscriptionIsAllowedToCreateJobValidationResponseProperties;
import com.azure.resourcemanager.databox.models.ValidationInputDiscriminator;
import java.io.IOException;

public class ValidationInputResponse
implements JsonSerializable<ValidationInputResponse> {
    private ValidationInputDiscriminator validationType;
    private CloudError error;

    public ValidationInputDiscriminator validationType() {
        return this.validationType;
    }

    public CloudError error() {
        return this.error;
    }

    ValidationInputResponse withError(CloudError error) {
        this.error = error;
        return this;
    }

    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("validationType", this.validationType == null ? null : this.validationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static ValidationInputResponse fromJson(JsonReader jsonReader) throws IOException {
        return (ValidationInputResponse)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ValidationInputResponse validationInputResponse;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("validationType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("ValidateAddress".equals(discriminatorValue)) {
                    validationInputResponse = AddressValidationProperties.fromJson(readerToUse.reset());
                    return validationInputResponse;
                }
                if ("ValidateCreateOrderLimit".equals(discriminatorValue)) {
                    validationInputResponse = CreateOrderLimitForSubscriptionValidationResponseProperties.fromJson(readerToUse.reset());
                    return validationInputResponse;
                }
                if ("ValidateDataTransferDetails".equals(discriminatorValue)) {
                    validationInputResponse = DataTransferDetailsValidationResponseProperties.fromJson(readerToUse.reset());
                    return validationInputResponse;
                }
                if ("ValidatePreferences".equals(discriminatorValue)) {
                    validationInputResponse = PreferencesValidationResponseProperties.fromJson(readerToUse.reset());
                    return validationInputResponse;
                }
                if ("ValidateSkuAvailability".equals(discriminatorValue)) {
                    validationInputResponse = SkuAvailabilityValidationResponseProperties.fromJson(readerToUse.reset());
                    return validationInputResponse;
                }
                if ("ValidateSubscriptionIsAllowedToCreateJob".equals(discriminatorValue)) {
                    validationInputResponse = SubscriptionIsAllowedToCreateJobValidationResponseProperties.fromJson(readerToUse.reset());
                    return validationInputResponse;
                }
                validationInputResponse = ValidationInputResponse.fromJsonKnownDiscriminator(readerToUse.reset());
                return validationInputResponse;
            }
        });
    }

    static ValidationInputResponse fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ValidationInputResponse)jsonReader.readObject(reader -> {
            ValidationInputResponse deserializedValidationInputResponse = new ValidationInputResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("validationType".equals(fieldName)) {
                    deserializedValidationInputResponse.validationType = ValidationInputDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedValidationInputResponse.error = CloudError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidationInputResponse;
        });
    }
}

