/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.CreateOrderLimitForSubscriptionValidationRequest;
import com.azure.resourcemanager.databox.models.DataTransferDetailsValidationRequest;
import com.azure.resourcemanager.databox.models.PreferencesValidationRequest;
import com.azure.resourcemanager.databox.models.SkuAvailabilityValidationRequest;
import com.azure.resourcemanager.databox.models.SubscriptionIsAllowedToCreateJobValidationRequest;
import com.azure.resourcemanager.databox.models.ValidateAddress;
import com.azure.resourcemanager.databox.models.ValidationInputDiscriminator;
import java.io.IOException;

public class ValidationInputRequest
implements JsonSerializable<ValidationInputRequest> {
    private ValidationInputDiscriminator validationType;

    public ValidationInputDiscriminator validationType() {
        return this.validationType;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("validationType", this.validationType == null ? null : this.validationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static ValidationInputRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ValidationInputRequest)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ValidationInputRequest validationInputRequest;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("validationType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("ValidateAddress".equals(discriminatorValue)) {
                    validationInputRequest = ValidateAddress.fromJson(readerToUse.reset());
                    return validationInputRequest;
                }
                if ("ValidateCreateOrderLimit".equals(discriminatorValue)) {
                    validationInputRequest = CreateOrderLimitForSubscriptionValidationRequest.fromJson(readerToUse.reset());
                    return validationInputRequest;
                }
                if ("ValidateDataTransferDetails".equals(discriminatorValue)) {
                    validationInputRequest = DataTransferDetailsValidationRequest.fromJson(readerToUse.reset());
                    return validationInputRequest;
                }
                if ("ValidatePreferences".equals(discriminatorValue)) {
                    validationInputRequest = PreferencesValidationRequest.fromJson(readerToUse.reset());
                    return validationInputRequest;
                }
                if ("ValidateSkuAvailability".equals(discriminatorValue)) {
                    validationInputRequest = SkuAvailabilityValidationRequest.fromJson(readerToUse.reset());
                    return validationInputRequest;
                }
                if ("ValidateSubscriptionIsAllowedToCreateJob".equals(discriminatorValue)) {
                    validationInputRequest = SubscriptionIsAllowedToCreateJobValidationRequest.fromJson(readerToUse.reset());
                    return validationInputRequest;
                }
                validationInputRequest = ValidationInputRequest.fromJsonKnownDiscriminator(readerToUse.reset());
                return validationInputRequest;
            }
        });
    }

    static ValidationInputRequest fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ValidationInputRequest)jsonReader.readObject(reader -> {
            ValidationInputRequest deserializedValidationInputRequest = new ValidationInputRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("validationType".equals(fieldName)) {
                    deserializedValidationInputRequest.validationType = ValidationInputDiscriminator.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidationInputRequest;
        });
    }
}

