/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ModelName;
import com.azure.resourcemanager.databox.models.ShippingAddress;
import com.azure.resourcemanager.databox.models.SkuName;
import com.azure.resourcemanager.databox.models.TransportPreferences;
import com.azure.resourcemanager.databox.models.ValidationInputDiscriminator;
import com.azure.resourcemanager.databox.models.ValidationInputRequest;
import java.io.IOException;

public final class ValidateAddress
extends ValidationInputRequest {
    private ValidationInputDiscriminator validationType = ValidationInputDiscriminator.VALIDATE_ADDRESS;
    private ShippingAddress shippingAddress;
    private SkuName deviceType;
    private TransportPreferences transportPreferences;
    private ModelName model;
    private static final ClientLogger LOGGER = new ClientLogger(ValidateAddress.class);

    @Override
    public ValidationInputDiscriminator validationType() {
        return this.validationType;
    }

    public ShippingAddress shippingAddress() {
        return this.shippingAddress;
    }

    public ValidateAddress withShippingAddress(ShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    public SkuName deviceType() {
        return this.deviceType;
    }

    public ValidateAddress withDeviceType(SkuName deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public TransportPreferences transportPreferences() {
        return this.transportPreferences;
    }

    public ValidateAddress withTransportPreferences(TransportPreferences transportPreferences) {
        this.transportPreferences = transportPreferences;
        return this;
    }

    public ModelName model() {
        return this.model;
    }

    public ValidateAddress withModel(ModelName model) {
        this.model = model;
        return this;
    }

    @Override
    public void validate() {
        if (this.shippingAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property shippingAddress in model ValidateAddress"));
        }
        this.shippingAddress().validate();
        if (this.deviceType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deviceType in model ValidateAddress"));
        }
        if (this.transportPreferences() != null) {
            this.transportPreferences().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("shippingAddress", (JsonSerializable)this.shippingAddress);
        jsonWriter.writeStringField("deviceType", this.deviceType == null ? null : this.deviceType.toString());
        jsonWriter.writeStringField("validationType", this.validationType == null ? null : this.validationType.toString());
        jsonWriter.writeJsonField("transportPreferences", (JsonSerializable)this.transportPreferences);
        jsonWriter.writeStringField("model", this.model == null ? null : this.model.toString());
        return jsonWriter.writeEndObject();
    }

    public static ValidateAddress fromJson(JsonReader jsonReader) throws IOException {
        return (ValidateAddress)jsonReader.readObject(reader -> {
            ValidateAddress deserializedValidateAddress = new ValidateAddress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("shippingAddress".equals(fieldName)) {
                    deserializedValidateAddress.shippingAddress = ShippingAddress.fromJson(reader);
                    continue;
                }
                if ("deviceType".equals(fieldName)) {
                    deserializedValidateAddress.deviceType = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("validationType".equals(fieldName)) {
                    deserializedValidateAddress.validationType = ValidationInputDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("transportPreferences".equals(fieldName)) {
                    deserializedValidateAddress.transportPreferences = TransportPreferences.fromJson(reader);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedValidateAddress.model = ModelName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidateAddress;
        });
    }
}

