/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ContactDetails;
import com.azure.resourcemanager.databox.models.KeyEncryptionKey;
import com.azure.resourcemanager.databox.models.PackageCarrierDetails;
import com.azure.resourcemanager.databox.models.Preferences;
import com.azure.resourcemanager.databox.models.ReverseShippingDetails;
import com.azure.resourcemanager.databox.models.ShippingAddress;
import java.io.IOException;

public final class UpdateJobDetails
implements JsonSerializable<UpdateJobDetails> {
    private ContactDetails contactDetails;
    private ShippingAddress shippingAddress;
    private ReverseShippingDetails reverseShippingDetails;
    private Preferences preferences;
    private KeyEncryptionKey keyEncryptionKey;
    private PackageCarrierDetails returnToCustomerPackageDetails;

    public ContactDetails contactDetails() {
        return this.contactDetails;
    }

    public UpdateJobDetails withContactDetails(ContactDetails contactDetails) {
        this.contactDetails = contactDetails;
        return this;
    }

    public ShippingAddress shippingAddress() {
        return this.shippingAddress;
    }

    public UpdateJobDetails withShippingAddress(ShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    public ReverseShippingDetails reverseShippingDetails() {
        return this.reverseShippingDetails;
    }

    public UpdateJobDetails withReverseShippingDetails(ReverseShippingDetails reverseShippingDetails) {
        this.reverseShippingDetails = reverseShippingDetails;
        return this;
    }

    public Preferences preferences() {
        return this.preferences;
    }

    public UpdateJobDetails withPreferences(Preferences preferences) {
        this.preferences = preferences;
        return this;
    }

    public KeyEncryptionKey keyEncryptionKey() {
        return this.keyEncryptionKey;
    }

    public UpdateJobDetails withKeyEncryptionKey(KeyEncryptionKey keyEncryptionKey) {
        this.keyEncryptionKey = keyEncryptionKey;
        return this;
    }

    public PackageCarrierDetails returnToCustomerPackageDetails() {
        return this.returnToCustomerPackageDetails;
    }

    public UpdateJobDetails withReturnToCustomerPackageDetails(PackageCarrierDetails returnToCustomerPackageDetails) {
        this.returnToCustomerPackageDetails = returnToCustomerPackageDetails;
        return this;
    }

    public void validate() {
        if (this.contactDetails() != null) {
            this.contactDetails().validate();
        }
        if (this.shippingAddress() != null) {
            this.shippingAddress().validate();
        }
        if (this.reverseShippingDetails() != null) {
            this.reverseShippingDetails().validate();
        }
        if (this.preferences() != null) {
            this.preferences().validate();
        }
        if (this.keyEncryptionKey() != null) {
            this.keyEncryptionKey().validate();
        }
        if (this.returnToCustomerPackageDetails() != null) {
            this.returnToCustomerPackageDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("contactDetails", (JsonSerializable)this.contactDetails);
        jsonWriter.writeJsonField("shippingAddress", (JsonSerializable)this.shippingAddress);
        jsonWriter.writeJsonField("reverseShippingDetails", (JsonSerializable)this.reverseShippingDetails);
        jsonWriter.writeJsonField("preferences", (JsonSerializable)this.preferences);
        jsonWriter.writeJsonField("keyEncryptionKey", (JsonSerializable)this.keyEncryptionKey);
        jsonWriter.writeJsonField("returnToCustomerPackageDetails", (JsonSerializable)this.returnToCustomerPackageDetails);
        return jsonWriter.writeEndObject();
    }

    public static UpdateJobDetails fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateJobDetails)jsonReader.readObject(reader -> {
            UpdateJobDetails deserializedUpdateJobDetails = new UpdateJobDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contactDetails".equals(fieldName)) {
                    deserializedUpdateJobDetails.contactDetails = ContactDetails.fromJson(reader);
                    continue;
                }
                if ("shippingAddress".equals(fieldName)) {
                    deserializedUpdateJobDetails.shippingAddress = ShippingAddress.fromJson(reader);
                    continue;
                }
                if ("reverseShippingDetails".equals(fieldName)) {
                    deserializedUpdateJobDetails.reverseShippingDetails = ReverseShippingDetails.fromJson(reader);
                    continue;
                }
                if ("preferences".equals(fieldName)) {
                    deserializedUpdateJobDetails.preferences = Preferences.fromJson(reader);
                    continue;
                }
                if ("keyEncryptionKey".equals(fieldName)) {
                    deserializedUpdateJobDetails.keyEncryptionKey = KeyEncryptionKey.fromJson(reader);
                    continue;
                }
                if ("returnToCustomerPackageDetails".equals(fieldName)) {
                    deserializedUpdateJobDetails.returnToCustomerPackageDetails = PackageCarrierDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateJobDetails;
        });
    }
}

