/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.TransportShipmentTypes;
import java.io.IOException;

public final class TransportPreferences
implements JsonSerializable<TransportPreferences> {
    private TransportShipmentTypes preferredShipmentType;
    private Boolean isUpdated;
    private static final ClientLogger LOGGER = new ClientLogger(TransportPreferences.class);

    public TransportShipmentTypes preferredShipmentType() {
        return this.preferredShipmentType;
    }

    public TransportPreferences withPreferredShipmentType(TransportShipmentTypes preferredShipmentType) {
        this.preferredShipmentType = preferredShipmentType;
        return this;
    }

    public Boolean isUpdated() {
        return this.isUpdated;
    }

    public void validate() {
        if (this.preferredShipmentType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property preferredShipmentType in model TransportPreferences"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("preferredShipmentType", this.preferredShipmentType == null ? null : this.preferredShipmentType.toString());
        return jsonWriter.writeEndObject();
    }

    public static TransportPreferences fromJson(JsonReader jsonReader) throws IOException {
        return (TransportPreferences)jsonReader.readObject(reader -> {
            TransportPreferences deserializedTransportPreferences = new TransportPreferences();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("preferredShipmentType".equals(fieldName)) {
                    deserializedTransportPreferences.preferredShipmentType = TransportShipmentTypes.fromString(reader.getString());
                    continue;
                }
                if ("isUpdated".equals(fieldName)) {
                    deserializedTransportPreferences.isUpdated = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTransportPreferences;
        });
    }
}

