/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.AzureFileFilterDetails;
import com.azure.resourcemanager.databox.models.BlobFilterDetails;
import com.azure.resourcemanager.databox.models.DataAccountType;
import com.azure.resourcemanager.databox.models.FilterFileDetails;
import java.io.IOException;
import java.util.List;

public final class TransferFilterDetails
implements JsonSerializable<TransferFilterDetails> {
    private DataAccountType dataAccountType;
    private BlobFilterDetails blobFilterDetails;
    private AzureFileFilterDetails azureFileFilterDetails;
    private List<FilterFileDetails> filterFileDetails;
    private static final ClientLogger LOGGER = new ClientLogger(TransferFilterDetails.class);

    public DataAccountType dataAccountType() {
        return this.dataAccountType;
    }

    public TransferFilterDetails withDataAccountType(DataAccountType dataAccountType) {
        this.dataAccountType = dataAccountType;
        return this;
    }

    public BlobFilterDetails blobFilterDetails() {
        return this.blobFilterDetails;
    }

    public TransferFilterDetails withBlobFilterDetails(BlobFilterDetails blobFilterDetails) {
        this.blobFilterDetails = blobFilterDetails;
        return this;
    }

    public AzureFileFilterDetails azureFileFilterDetails() {
        return this.azureFileFilterDetails;
    }

    public TransferFilterDetails withAzureFileFilterDetails(AzureFileFilterDetails azureFileFilterDetails) {
        this.azureFileFilterDetails = azureFileFilterDetails;
        return this;
    }

    public List<FilterFileDetails> filterFileDetails() {
        return this.filterFileDetails;
    }

    public TransferFilterDetails withFilterFileDetails(List<FilterFileDetails> filterFileDetails) {
        this.filterFileDetails = filterFileDetails;
        return this;
    }

    public void validate() {
        if (this.dataAccountType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataAccountType in model TransferFilterDetails"));
        }
        if (this.blobFilterDetails() != null) {
            this.blobFilterDetails().validate();
        }
        if (this.azureFileFilterDetails() != null) {
            this.azureFileFilterDetails().validate();
        }
        if (this.filterFileDetails() != null) {
            this.filterFileDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataAccountType", this.dataAccountType == null ? null : this.dataAccountType.toString());
        jsonWriter.writeJsonField("blobFilterDetails", (JsonSerializable)this.blobFilterDetails);
        jsonWriter.writeJsonField("azureFileFilterDetails", (JsonSerializable)this.azureFileFilterDetails);
        jsonWriter.writeArrayField("filterFileDetails", this.filterFileDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TransferFilterDetails fromJson(JsonReader jsonReader) throws IOException {
        return (TransferFilterDetails)jsonReader.readObject(reader -> {
            TransferFilterDetails deserializedTransferFilterDetails = new TransferFilterDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataAccountType".equals(fieldName)) {
                    deserializedTransferFilterDetails.dataAccountType = DataAccountType.fromString(reader.getString());
                    continue;
                }
                if ("blobFilterDetails".equals(fieldName)) {
                    deserializedTransferFilterDetails.blobFilterDetails = BlobFilterDetails.fromJson(reader);
                    continue;
                }
                if ("azureFileFilterDetails".equals(fieldName)) {
                    deserializedTransferFilterDetails.azureFileFilterDetails = AzureFileFilterDetails.fromJson(reader);
                    continue;
                }
                if ("filterFileDetails".equals(fieldName)) {
                    List filterFileDetails;
                    deserializedTransferFilterDetails.filterFileDetails = filterFileDetails = reader.readArray(reader1 -> FilterFileDetails.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTransferFilterDetails;
        });
    }
}

