/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.TransferConfigurationTransferAllDetails;
import com.azure.resourcemanager.databox.models.TransferConfigurationTransferFilterDetails;
import com.azure.resourcemanager.databox.models.TransferConfigurationType;
import java.io.IOException;

public final class TransferConfiguration
implements JsonSerializable<TransferConfiguration> {
    private TransferConfigurationType transferConfigurationType;
    private TransferConfigurationTransferFilterDetails transferFilterDetails;
    private TransferConfigurationTransferAllDetails transferAllDetails;
    private static final ClientLogger LOGGER = new ClientLogger(TransferConfiguration.class);

    public TransferConfigurationType transferConfigurationType() {
        return this.transferConfigurationType;
    }

    public TransferConfiguration withTransferConfigurationType(TransferConfigurationType transferConfigurationType) {
        this.transferConfigurationType = transferConfigurationType;
        return this;
    }

    public TransferConfigurationTransferFilterDetails transferFilterDetails() {
        return this.transferFilterDetails;
    }

    public TransferConfiguration withTransferFilterDetails(TransferConfigurationTransferFilterDetails transferFilterDetails) {
        this.transferFilterDetails = transferFilterDetails;
        return this;
    }

    public TransferConfigurationTransferAllDetails transferAllDetails() {
        return this.transferAllDetails;
    }

    public TransferConfiguration withTransferAllDetails(TransferConfigurationTransferAllDetails transferAllDetails) {
        this.transferAllDetails = transferAllDetails;
        return this;
    }

    public void validate() {
        if (this.transferConfigurationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property transferConfigurationType in model TransferConfiguration"));
        }
        if (this.transferFilterDetails() != null) {
            this.transferFilterDetails().validate();
        }
        if (this.transferAllDetails() != null) {
            this.transferAllDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transferConfigurationType", this.transferConfigurationType == null ? null : this.transferConfigurationType.toString());
        jsonWriter.writeJsonField("transferFilterDetails", (JsonSerializable)this.transferFilterDetails);
        jsonWriter.writeJsonField("transferAllDetails", (JsonSerializable)this.transferAllDetails);
        return jsonWriter.writeEndObject();
    }

    public static TransferConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (TransferConfiguration)jsonReader.readObject(reader -> {
            TransferConfiguration deserializedTransferConfiguration = new TransferConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transferConfigurationType".equals(fieldName)) {
                    deserializedTransferConfiguration.transferConfigurationType = TransferConfigurationType.fromString(reader.getString());
                    continue;
                }
                if ("transferFilterDetails".equals(fieldName)) {
                    deserializedTransferConfiguration.transferFilterDetails = TransferConfigurationTransferFilterDetails.fromJson(reader);
                    continue;
                }
                if ("transferAllDetails".equals(fieldName)) {
                    deserializedTransferConfiguration.transferAllDetails = TransferConfigurationTransferAllDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTransferConfiguration;
        });
    }
}

