/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DataAccountType;
import java.io.IOException;

public final class TransferAllDetails
implements JsonSerializable<TransferAllDetails> {
    private DataAccountType dataAccountType;
    private Boolean transferAllBlobs;
    private Boolean transferAllFiles;
    private static final ClientLogger LOGGER = new ClientLogger(TransferAllDetails.class);

    public DataAccountType dataAccountType() {
        return this.dataAccountType;
    }

    public TransferAllDetails withDataAccountType(DataAccountType dataAccountType) {
        this.dataAccountType = dataAccountType;
        return this;
    }

    public Boolean transferAllBlobs() {
        return this.transferAllBlobs;
    }

    public TransferAllDetails withTransferAllBlobs(Boolean transferAllBlobs) {
        this.transferAllBlobs = transferAllBlobs;
        return this;
    }

    public Boolean transferAllFiles() {
        return this.transferAllFiles;
    }

    public TransferAllDetails withTransferAllFiles(Boolean transferAllFiles) {
        this.transferAllFiles = transferAllFiles;
        return this;
    }

    public void validate() {
        if (this.dataAccountType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataAccountType in model TransferAllDetails"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataAccountType", this.dataAccountType == null ? null : this.dataAccountType.toString());
        jsonWriter.writeBooleanField("transferAllBlobs", this.transferAllBlobs);
        jsonWriter.writeBooleanField("transferAllFiles", this.transferAllFiles);
        return jsonWriter.writeEndObject();
    }

    public static TransferAllDetails fromJson(JsonReader jsonReader) throws IOException {
        return (TransferAllDetails)jsonReader.readObject(reader -> {
            TransferAllDetails deserializedTransferAllDetails = new TransferAllDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataAccountType".equals(fieldName)) {
                    deserializedTransferAllDetails.dataAccountType = DataAccountType.fromString(reader.getString());
                    continue;
                }
                if ("transferAllBlobs".equals(fieldName)) {
                    deserializedTransferAllDetails.transferAllBlobs = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("transferAllFiles".equals(fieldName)) {
                    deserializedTransferAllDetails.transferAllFiles = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTransferAllDetails;
        });
    }
}

