/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DataAccountDetails;
import com.azure.resourcemanager.databox.models.DataAccountType;
import java.io.IOException;

public final class StorageAccountDetails
extends DataAccountDetails {
    private DataAccountType dataAccountType = DataAccountType.STORAGE_ACCOUNT;
    private String storageAccountId;
    private static final ClientLogger LOGGER = new ClientLogger(StorageAccountDetails.class);

    @Override
    public DataAccountType dataAccountType() {
        return this.dataAccountType;
    }

    public String storageAccountId() {
        return this.storageAccountId;
    }

    public StorageAccountDetails withStorageAccountId(String storageAccountId) {
        this.storageAccountId = storageAccountId;
        return this;
    }

    @Override
    public StorageAccountDetails withSharePassword(String sharePassword) {
        super.withSharePassword(sharePassword);
        return this;
    }

    @Override
    public void validate() {
        if (this.storageAccountId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageAccountId in model StorageAccountDetails"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sharePassword", this.sharePassword());
        jsonWriter.writeStringField("storageAccountId", this.storageAccountId);
        jsonWriter.writeStringField("dataAccountType", this.dataAccountType == null ? null : this.dataAccountType.toString());
        return jsonWriter.writeEndObject();
    }

    public static StorageAccountDetails fromJson(JsonReader jsonReader) throws IOException {
        return (StorageAccountDetails)jsonReader.readObject(reader -> {
            StorageAccountDetails deserializedStorageAccountDetails = new StorageAccountDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sharePassword".equals(fieldName)) {
                    deserializedStorageAccountDetails.withSharePassword(reader.getString());
                    continue;
                }
                if ("storageAccountId".equals(fieldName)) {
                    deserializedStorageAccountDetails.storageAccountId = reader.getString();
                    continue;
                }
                if ("dataAccountType".equals(fieldName)) {
                    deserializedStorageAccountDetails.dataAccountType = DataAccountType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAccountDetails;
        });
    }
}

