/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ModelName;
import com.azure.resourcemanager.databox.models.SkuName;
import com.azure.resourcemanager.databox.models.TransferType;
import com.azure.resourcemanager.databox.models.ValidationInputDiscriminator;
import com.azure.resourcemanager.databox.models.ValidationInputRequest;
import java.io.IOException;

public final class SkuAvailabilityValidationRequest
extends ValidationInputRequest {
    private ValidationInputDiscriminator validationType = ValidationInputDiscriminator.VALIDATE_SKU_AVAILABILITY;
    private SkuName deviceType;
    private TransferType transferType;
    private String country;
    private String location;
    private ModelName model;
    private static final ClientLogger LOGGER = new ClientLogger(SkuAvailabilityValidationRequest.class);

    @Override
    public ValidationInputDiscriminator validationType() {
        return this.validationType;
    }

    public SkuName deviceType() {
        return this.deviceType;
    }

    public SkuAvailabilityValidationRequest withDeviceType(SkuName deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public TransferType transferType() {
        return this.transferType;
    }

    public SkuAvailabilityValidationRequest withTransferType(TransferType transferType) {
        this.transferType = transferType;
        return this;
    }

    public String country() {
        return this.country;
    }

    public SkuAvailabilityValidationRequest withCountry(String country) {
        this.country = country;
        return this;
    }

    public String location() {
        return this.location;
    }

    public SkuAvailabilityValidationRequest withLocation(String location) {
        this.location = location;
        return this;
    }

    public ModelName model() {
        return this.model;
    }

    public SkuAvailabilityValidationRequest withModel(ModelName model) {
        this.model = model;
        return this;
    }

    @Override
    public void validate() {
        if (this.deviceType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deviceType in model SkuAvailabilityValidationRequest"));
        }
        if (this.transferType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property transferType in model SkuAvailabilityValidationRequest"));
        }
        if (this.country() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property country in model SkuAvailabilityValidationRequest"));
        }
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model SkuAvailabilityValidationRequest"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deviceType", this.deviceType == null ? null : this.deviceType.toString());
        jsonWriter.writeStringField("transferType", this.transferType == null ? null : this.transferType.toString());
        jsonWriter.writeStringField("country", this.country);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeStringField("validationType", this.validationType == null ? null : this.validationType.toString());
        jsonWriter.writeStringField("model", this.model == null ? null : this.model.toString());
        return jsonWriter.writeEndObject();
    }

    public static SkuAvailabilityValidationRequest fromJson(JsonReader jsonReader) throws IOException {
        return (SkuAvailabilityValidationRequest)jsonReader.readObject(reader -> {
            SkuAvailabilityValidationRequest deserializedSkuAvailabilityValidationRequest = new SkuAvailabilityValidationRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deviceType".equals(fieldName)) {
                    deserializedSkuAvailabilityValidationRequest.deviceType = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("transferType".equals(fieldName)) {
                    deserializedSkuAvailabilityValidationRequest.transferType = TransferType.fromString(reader.getString());
                    continue;
                }
                if ("country".equals(fieldName)) {
                    deserializedSkuAvailabilityValidationRequest.country = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSkuAvailabilityValidationRequest.location = reader.getString();
                    continue;
                }
                if ("validationType".equals(fieldName)) {
                    deserializedSkuAvailabilityValidationRequest.validationType = ValidationInputDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedSkuAvailabilityValidationRequest.model = ModelName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuAvailabilityValidationRequest;
        });
    }
}

