/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ModelName;
import com.azure.resourcemanager.databox.models.SkuName;
import java.io.IOException;

public final class Sku
implements JsonSerializable<Sku> {
    private SkuName name;
    private String displayName;
    private String family;
    private ModelName model;
    private static final ClientLogger LOGGER = new ClientLogger(Sku.class);

    public SkuName name() {
        return this.name;
    }

    public Sku withName(SkuName name) {
        this.name = name;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public Sku withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String family() {
        return this.family;
    }

    public Sku withFamily(String family) {
        this.family = family;
        return this;
    }

    public ModelName model() {
        return this.model;
    }

    public Sku withModel(ModelName model) {
        this.model = model;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model Sku"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("family", this.family);
        jsonWriter.writeStringField("model", this.model == null ? null : this.model.toString());
        return jsonWriter.writeEndObject();
    }

    public static Sku fromJson(JsonReader jsonReader) throws IOException {
        return (Sku)jsonReader.readObject(reader -> {
            Sku deserializedSku = new Sku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSku.name = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedSku.displayName = reader.getString();
                    continue;
                }
                if ("family".equals(fieldName)) {
                    deserializedSku.family = reader.getString();
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedSku.model = ModelName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSku;
        });
    }
}

