/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.AddressType;
import java.io.IOException;

public final class ShippingAddress
implements JsonSerializable<ShippingAddress> {
    private String streetAddress1;
    private String streetAddress2;
    private String streetAddress3;
    private String city;
    private String stateOrProvince;
    private String country;
    private String postalCode;
    private String zipExtendedCode;
    private String companyName;
    private AddressType addressType;
    private Boolean skipAddressValidation;
    private String taxIdentificationNumber;
    private static final ClientLogger LOGGER = new ClientLogger(ShippingAddress.class);

    public String streetAddress1() {
        return this.streetAddress1;
    }

    public ShippingAddress withStreetAddress1(String streetAddress1) {
        this.streetAddress1 = streetAddress1;
        return this;
    }

    public String streetAddress2() {
        return this.streetAddress2;
    }

    public ShippingAddress withStreetAddress2(String streetAddress2) {
        this.streetAddress2 = streetAddress2;
        return this;
    }

    public String streetAddress3() {
        return this.streetAddress3;
    }

    public ShippingAddress withStreetAddress3(String streetAddress3) {
        this.streetAddress3 = streetAddress3;
        return this;
    }

    public String city() {
        return this.city;
    }

    public ShippingAddress withCity(String city) {
        this.city = city;
        return this;
    }

    public String stateOrProvince() {
        return this.stateOrProvince;
    }

    public ShippingAddress withStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    public String country() {
        return this.country;
    }

    public ShippingAddress withCountry(String country) {
        this.country = country;
        return this;
    }

    public String postalCode() {
        return this.postalCode;
    }

    public ShippingAddress withPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    public String zipExtendedCode() {
        return this.zipExtendedCode;
    }

    public ShippingAddress withZipExtendedCode(String zipExtendedCode) {
        this.zipExtendedCode = zipExtendedCode;
        return this;
    }

    public String companyName() {
        return this.companyName;
    }

    public ShippingAddress withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    public AddressType addressType() {
        return this.addressType;
    }

    public ShippingAddress withAddressType(AddressType addressType) {
        this.addressType = addressType;
        return this;
    }

    public Boolean skipAddressValidation() {
        return this.skipAddressValidation;
    }

    public ShippingAddress withSkipAddressValidation(Boolean skipAddressValidation) {
        this.skipAddressValidation = skipAddressValidation;
        return this;
    }

    public String taxIdentificationNumber() {
        return this.taxIdentificationNumber;
    }

    public ShippingAddress withTaxIdentificationNumber(String taxIdentificationNumber) {
        this.taxIdentificationNumber = taxIdentificationNumber;
        return this;
    }

    public void validate() {
        if (this.streetAddress1() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property streetAddress1 in model ShippingAddress"));
        }
        if (this.country() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property country in model ShippingAddress"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("streetAddress1", this.streetAddress1);
        jsonWriter.writeStringField("country", this.country);
        jsonWriter.writeStringField("streetAddress2", this.streetAddress2);
        jsonWriter.writeStringField("streetAddress3", this.streetAddress3);
        jsonWriter.writeStringField("city", this.city);
        jsonWriter.writeStringField("stateOrProvince", this.stateOrProvince);
        jsonWriter.writeStringField("postalCode", this.postalCode);
        jsonWriter.writeStringField("zipExtendedCode", this.zipExtendedCode);
        jsonWriter.writeStringField("companyName", this.companyName);
        jsonWriter.writeStringField("addressType", this.addressType == null ? null : this.addressType.toString());
        jsonWriter.writeBooleanField("skipAddressValidation", this.skipAddressValidation);
        jsonWriter.writeStringField("taxIdentificationNumber", this.taxIdentificationNumber);
        return jsonWriter.writeEndObject();
    }

    public static ShippingAddress fromJson(JsonReader jsonReader) throws IOException {
        return (ShippingAddress)jsonReader.readObject(reader -> {
            ShippingAddress deserializedShippingAddress = new ShippingAddress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("streetAddress1".equals(fieldName)) {
                    deserializedShippingAddress.streetAddress1 = reader.getString();
                    continue;
                }
                if ("country".equals(fieldName)) {
                    deserializedShippingAddress.country = reader.getString();
                    continue;
                }
                if ("streetAddress2".equals(fieldName)) {
                    deserializedShippingAddress.streetAddress2 = reader.getString();
                    continue;
                }
                if ("streetAddress3".equals(fieldName)) {
                    deserializedShippingAddress.streetAddress3 = reader.getString();
                    continue;
                }
                if ("city".equals(fieldName)) {
                    deserializedShippingAddress.city = reader.getString();
                    continue;
                }
                if ("stateOrProvince".equals(fieldName)) {
                    deserializedShippingAddress.stateOrProvince = reader.getString();
                    continue;
                }
                if ("postalCode".equals(fieldName)) {
                    deserializedShippingAddress.postalCode = reader.getString();
                    continue;
                }
                if ("zipExtendedCode".equals(fieldName)) {
                    deserializedShippingAddress.zipExtendedCode = reader.getString();
                    continue;
                }
                if ("companyName".equals(fieldName)) {
                    deserializedShippingAddress.companyName = reader.getString();
                    continue;
                }
                if ("addressType".equals(fieldName)) {
                    deserializedShippingAddress.addressType = AddressType.fromString(reader.getString());
                    continue;
                }
                if ("skipAddressValidation".equals(fieldName)) {
                    deserializedShippingAddress.skipAddressValidation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("taxIdentificationNumber".equals(fieldName)) {
                    deserializedShippingAddress.taxIdentificationNumber = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedShippingAddress;
        });
    }
}

