/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ShipmentPickUpRequest
implements JsonSerializable<ShipmentPickUpRequest> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String shipmentLocation;
    private static final ClientLogger LOGGER = new ClientLogger(ShipmentPickUpRequest.class);

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public ShipmentPickUpRequest withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public ShipmentPickUpRequest withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public String shipmentLocation() {
        return this.shipmentLocation;
    }

    public ShipmentPickUpRequest withShipmentLocation(String shipmentLocation) {
        this.shipmentLocation = shipmentLocation;
        return this;
    }

    public void validate() {
        if (this.startTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property startTime in model ShipmentPickUpRequest"));
        }
        if (this.endTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endTime in model ShipmentPickUpRequest"));
        }
        if (this.shipmentLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property shipmentLocation in model ShipmentPickUpRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("shipmentLocation", this.shipmentLocation);
        return jsonWriter.writeEndObject();
    }

    public static ShipmentPickUpRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ShipmentPickUpRequest)jsonReader.readObject(reader -> {
            ShipmentPickUpRequest deserializedShipmentPickUpRequest = new ShipmentPickUpRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedShipmentPickUpRequest.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedShipmentPickUpRequest.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("shipmentLocation".equals(fieldName)) {
                    deserializedShipmentPickUpRequest.shipmentLocation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedShipmentPickUpRequest;
        });
    }
}

