/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DataBoxScheduleAvailabilityRequest;
import com.azure.resourcemanager.databox.models.DiskScheduleAvailabilityRequest;
import com.azure.resourcemanager.databox.models.HeavyScheduleAvailabilityRequest;
import com.azure.resourcemanager.databox.models.ModelName;
import com.azure.resourcemanager.databox.models.SkuName;
import java.io.IOException;

public class ScheduleAvailabilityRequest
implements JsonSerializable<ScheduleAvailabilityRequest> {
    private SkuName skuName;
    private String storageLocation;
    private String country;
    private ModelName model;
    private static final ClientLogger LOGGER = new ClientLogger(ScheduleAvailabilityRequest.class);

    public SkuName skuName() {
        return this.skuName;
    }

    public String storageLocation() {
        return this.storageLocation;
    }

    public ScheduleAvailabilityRequest withStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
        return this;
    }

    public String country() {
        return this.country;
    }

    public ScheduleAvailabilityRequest withCountry(String country) {
        this.country = country;
        return this;
    }

    public ModelName model() {
        return this.model;
    }

    public ScheduleAvailabilityRequest withModel(ModelName model) {
        this.model = model;
        return this;
    }

    public void validate() {
        if (this.storageLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageLocation in model ScheduleAvailabilityRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageLocation", this.storageLocation);
        jsonWriter.writeStringField("skuName", this.skuName == null ? null : this.skuName.toString());
        jsonWriter.writeStringField("country", this.country);
        jsonWriter.writeStringField("model", this.model == null ? null : this.model.toString());
        return jsonWriter.writeEndObject();
    }

    public static ScheduleAvailabilityRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleAvailabilityRequest)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ScheduleAvailabilityRequest scheduleAvailabilityRequest;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("skuName".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("DataBox".equals(discriminatorValue)) {
                    scheduleAvailabilityRequest = DataBoxScheduleAvailabilityRequest.fromJson(readerToUse.reset());
                    return scheduleAvailabilityRequest;
                }
                if ("DataBoxDisk".equals(discriminatorValue)) {
                    scheduleAvailabilityRequest = DiskScheduleAvailabilityRequest.fromJson(readerToUse.reset());
                    return scheduleAvailabilityRequest;
                }
                if ("DataBoxHeavy".equals(discriminatorValue)) {
                    scheduleAvailabilityRequest = HeavyScheduleAvailabilityRequest.fromJson(readerToUse.reset());
                    return scheduleAvailabilityRequest;
                }
                scheduleAvailabilityRequest = ScheduleAvailabilityRequest.fromJsonKnownDiscriminator(readerToUse.reset());
                return scheduleAvailabilityRequest;
            }
        });
    }

    static ScheduleAvailabilityRequest fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ScheduleAvailabilityRequest)jsonReader.readObject(reader -> {
            ScheduleAvailabilityRequest deserializedScheduleAvailabilityRequest = new ScheduleAvailabilityRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageLocation".equals(fieldName)) {
                    deserializedScheduleAvailabilityRequest.storageLocation = reader.getString();
                    continue;
                }
                if ("skuName".equals(fieldName)) {
                    deserializedScheduleAvailabilityRequest.skuName = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("country".equals(fieldName)) {
                    deserializedScheduleAvailabilityRequest.country = reader.getString();
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedScheduleAvailabilityRequest.model = ModelName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduleAvailabilityRequest;
        });
    }
}

