/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.UserAssignedIdentity;
import java.io.IOException;
import java.util.Map;

public final class ResourceIdentity
implements JsonSerializable<ResourceIdentity> {
    private String type;
    private String principalId;
    private String tenantId;
    private Map<String, UserAssignedIdentity> userAssignedIdentities;

    public String type() {
        return this.type;
    }

    public ResourceIdentity withType(String type) {
        this.type = type;
        return this;
    }

    public String principalId() {
        return this.principalId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public Map<String, UserAssignedIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public ResourceIdentity withUserAssignedIdentities(Map<String, UserAssignedIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceIdentity)jsonReader.readObject(reader -> {
            ResourceIdentity deserializedResourceIdentity = new ResourceIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedResourceIdentity.type = reader.getString();
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedResourceIdentity.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedResourceIdentity.tenantId = reader.getString();
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedResourceIdentity.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> UserAssignedIdentity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceIdentity;
        });
    }
}

