/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DatacenterAddressRequest;
import com.azure.resourcemanager.databox.models.DeviceCapabilityRequest;
import com.azure.resourcemanager.databox.models.ScheduleAvailabilityRequest;
import com.azure.resourcemanager.databox.models.TransportAvailabilityRequest;
import java.io.IOException;

public final class RegionConfigurationRequest
implements JsonSerializable<RegionConfigurationRequest> {
    private ScheduleAvailabilityRequest scheduleAvailabilityRequest;
    private TransportAvailabilityRequest transportAvailabilityRequest;
    private DatacenterAddressRequest datacenterAddressRequest;
    private DeviceCapabilityRequest deviceCapabilityRequest;

    public ScheduleAvailabilityRequest scheduleAvailabilityRequest() {
        return this.scheduleAvailabilityRequest;
    }

    public RegionConfigurationRequest withScheduleAvailabilityRequest(ScheduleAvailabilityRequest scheduleAvailabilityRequest) {
        this.scheduleAvailabilityRequest = scheduleAvailabilityRequest;
        return this;
    }

    public TransportAvailabilityRequest transportAvailabilityRequest() {
        return this.transportAvailabilityRequest;
    }

    public RegionConfigurationRequest withTransportAvailabilityRequest(TransportAvailabilityRequest transportAvailabilityRequest) {
        this.transportAvailabilityRequest = transportAvailabilityRequest;
        return this;
    }

    public DatacenterAddressRequest datacenterAddressRequest() {
        return this.datacenterAddressRequest;
    }

    public RegionConfigurationRequest withDatacenterAddressRequest(DatacenterAddressRequest datacenterAddressRequest) {
        this.datacenterAddressRequest = datacenterAddressRequest;
        return this;
    }

    public DeviceCapabilityRequest deviceCapabilityRequest() {
        return this.deviceCapabilityRequest;
    }

    public RegionConfigurationRequest withDeviceCapabilityRequest(DeviceCapabilityRequest deviceCapabilityRequest) {
        this.deviceCapabilityRequest = deviceCapabilityRequest;
        return this;
    }

    public void validate() {
        if (this.scheduleAvailabilityRequest() != null) {
            this.scheduleAvailabilityRequest().validate();
        }
        if (this.transportAvailabilityRequest() != null) {
            this.transportAvailabilityRequest().validate();
        }
        if (this.datacenterAddressRequest() != null) {
            this.datacenterAddressRequest().validate();
        }
        if (this.deviceCapabilityRequest() != null) {
            this.deviceCapabilityRequest().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("scheduleAvailabilityRequest", (JsonSerializable)this.scheduleAvailabilityRequest);
        jsonWriter.writeJsonField("transportAvailabilityRequest", (JsonSerializable)this.transportAvailabilityRequest);
        jsonWriter.writeJsonField("datacenterAddressRequest", (JsonSerializable)this.datacenterAddressRequest);
        jsonWriter.writeJsonField("deviceCapabilityRequest", (JsonSerializable)this.deviceCapabilityRequest);
        return jsonWriter.writeEndObject();
    }

    public static RegionConfigurationRequest fromJson(JsonReader jsonReader) throws IOException {
        return (RegionConfigurationRequest)jsonReader.readObject(reader -> {
            RegionConfigurationRequest deserializedRegionConfigurationRequest = new RegionConfigurationRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scheduleAvailabilityRequest".equals(fieldName)) {
                    deserializedRegionConfigurationRequest.scheduleAvailabilityRequest = ScheduleAvailabilityRequest.fromJson(reader);
                    continue;
                }
                if ("transportAvailabilityRequest".equals(fieldName)) {
                    deserializedRegionConfigurationRequest.transportAvailabilityRequest = TransportAvailabilityRequest.fromJson(reader);
                    continue;
                }
                if ("datacenterAddressRequest".equals(fieldName)) {
                    deserializedRegionConfigurationRequest.datacenterAddressRequest = DatacenterAddressRequest.fromJson(reader);
                    continue;
                }
                if ("deviceCapabilityRequest".equals(fieldName)) {
                    deserializedRegionConfigurationRequest.deviceCapabilityRequest = DeviceCapabilityRequest.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRegionConfigurationRequest;
        });
    }
}

