/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.ValidationInputDiscriminator;
import com.azure.resourcemanager.databox.models.ValidationInputResponse;
import com.azure.resourcemanager.databox.models.ValidationStatus;
import java.io.IOException;

public final class PreferencesValidationResponseProperties
extends ValidationInputResponse {
    private ValidationInputDiscriminator validationType = ValidationInputDiscriminator.VALIDATE_PREFERENCES;
    private ValidationStatus status;

    @Override
    public ValidationInputDiscriminator validationType() {
        return this.validationType;
    }

    public ValidationStatus status() {
        return this.status;
    }

    @Override
    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("validationType", this.validationType == null ? null : this.validationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static PreferencesValidationResponseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PreferencesValidationResponseProperties)jsonReader.readObject(reader -> {
            PreferencesValidationResponseProperties deserializedPreferencesValidationResponseProperties = new PreferencesValidationResponseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("error".equals(fieldName)) {
                    deserializedPreferencesValidationResponseProperties.withError(CloudError.fromJson(reader));
                    continue;
                }
                if ("validationType".equals(fieldName)) {
                    deserializedPreferencesValidationResponseProperties.validationType = ValidationInputDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedPreferencesValidationResponseProperties.status = ValidationStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPreferencesValidationResponseProperties;
        });
    }
}

