/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.ModelName;
import com.azure.resourcemanager.databox.models.Preferences;
import com.azure.resourcemanager.databox.models.SkuName;
import com.azure.resourcemanager.databox.models.ValidationInputDiscriminator;
import com.azure.resourcemanager.databox.models.ValidationInputRequest;
import java.io.IOException;

public final class PreferencesValidationRequest
extends ValidationInputRequest {
    private ValidationInputDiscriminator validationType = ValidationInputDiscriminator.VALIDATE_PREFERENCES;
    private Preferences preference;
    private SkuName deviceType;
    private ModelName model;
    private static final ClientLogger LOGGER = new ClientLogger(PreferencesValidationRequest.class);

    @Override
    public ValidationInputDiscriminator validationType() {
        return this.validationType;
    }

    public Preferences preference() {
        return this.preference;
    }

    public PreferencesValidationRequest withPreference(Preferences preference) {
        this.preference = preference;
        return this;
    }

    public SkuName deviceType() {
        return this.deviceType;
    }

    public PreferencesValidationRequest withDeviceType(SkuName deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public ModelName model() {
        return this.model;
    }

    public PreferencesValidationRequest withModel(ModelName model) {
        this.model = model;
        return this;
    }

    @Override
    public void validate() {
        if (this.preference() != null) {
            this.preference().validate();
        }
        if (this.deviceType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deviceType in model PreferencesValidationRequest"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deviceType", this.deviceType == null ? null : this.deviceType.toString());
        jsonWriter.writeStringField("validationType", this.validationType == null ? null : this.validationType.toString());
        jsonWriter.writeJsonField("preference", (JsonSerializable)this.preference);
        jsonWriter.writeStringField("model", this.model == null ? null : this.model.toString());
        return jsonWriter.writeEndObject();
    }

    public static PreferencesValidationRequest fromJson(JsonReader jsonReader) throws IOException {
        return (PreferencesValidationRequest)jsonReader.readObject(reader -> {
            PreferencesValidationRequest deserializedPreferencesValidationRequest = new PreferencesValidationRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deviceType".equals(fieldName)) {
                    deserializedPreferencesValidationRequest.deviceType = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("validationType".equals(fieldName)) {
                    deserializedPreferencesValidationRequest.validationType = ValidationInputDiscriminator.fromString(reader.getString());
                    continue;
                }
                if ("preference".equals(fieldName)) {
                    deserializedPreferencesValidationRequest.preference = Preferences.fromJson(reader);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedPreferencesValidationRequest.model = ModelName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPreferencesValidationRequest;
        });
    }
}

